/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.rules;

import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.rules.AbstractConditionedParseRule;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.preprocessing.filter.ChangeAttributeRole;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.XMLException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetRoleByNameRule
extends AbstractConditionedParseRule {
    private String parameterName;
    private String targetRole;

    public SetRoleByNameRule(String operatorTypeName, Element element) throws XMLException {
        super(operatorTypeName, element);
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElem = (Element)child;
            if (childElem.getTagName().equals("role")) {
                this.targetRole = childElem.getTextContent();
                continue;
            }
            if (!childElem.getTagName().equals("parameter")) continue;
            this.parameterName = childElem.getTextContent();
        }
    }

    @Override
    protected String conditionedApply(Operator operator, String operatorTypeName, XMLImporter importer) {
        if (operator.getParameters().isSpecified(this.parameterName)) {
            try {
                String attributeName = operator.getParameterAsString(this.parameterName);
                ChangeAttributeRole setRoleOp = OperatorService.createOperator(ChangeAttributeRole.class);
                ExecutionUnit process = operator.getExecutionUnit();
                int operatorIndex = process.getOperators().indexOf(operator);
                process.addOperator((Operator)setRoleOp, operatorIndex + 1);
                setRoleOp.setParameter("name", attributeName);
                setRoleOp.setParameter("target_role", this.targetRole);
                return "Inserted operator for explicitly setting attribute <code>" + attributeName + "</code> to role <code>" + this.targetRole + "</code>";
            }
            catch (UndefinedParameterError e) {
                return null;
            }
            catch (OperatorCreationException e) {
                return null;
            }
        }
        return null;
    }

    public String toString() {
        return "Set role of attribute specified in the parameter " + this.parameterName + " to " + this.targetRole + ".";
    }
}

