/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.rules;

import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.rules.AbstractConditionedParseRule;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.XMLException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetParameterRule
extends AbstractConditionedParseRule {
    private String attributeName;
    private String value;

    public SetParameterRule(String operatorTypeName, Element element) throws XMLException {
        super(operatorTypeName, element);
        assert (element.getTagName().equals("setParameter"));
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElem = (Element)child;
            if (childElem.getTagName().equals("attribute")) {
                this.attributeName = childElem.getTextContent();
                continue;
            }
            if (!childElem.getTagName().equals("value")) continue;
            this.value = childElem.getTextContent();
        }
    }

    @Override
    protected String conditionedApply(Operator operator, String operatorTypeName, XMLImporter importer) {
        operator.getParameters().setParameter(this.attributeName, this.value);
        return "Parameter <code>" + this.attributeName + "</code> in <var>" + operator.getName() + "</var> (<code>" + operatorTypeName + "</code>) was set to <code>" + this.value + "</code>.";
    }

    public String toString() {
        return "Set " + this.operatorTypeName + "." + this.attributeName + " to " + this.value;
    }
}

