/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.rules;

import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.rules.AbstractConditionedParseRule;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.XMLException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReplaceParameterRule
extends AbstractConditionedParseRule {
    private String oldAttributeName;
    private String newAttributeName;

    public ReplaceParameterRule(String operatorTypeName, Element element) throws XMLException {
        super(operatorTypeName, element);
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElem = (Element)child;
            if (childElem.getTagName().equals("oldparameter")) {
                this.oldAttributeName = childElem.getTextContent();
                continue;
            }
            if (!childElem.getTagName().equals("newparameter")) continue;
            this.newAttributeName = childElem.getTextContent();
        }
    }

    @Override
    protected String conditionedApply(Operator operator, String operatorTypeName, XMLImporter importer) {
        if (operator.getParameters().isSpecified(this.oldAttributeName)) {
            operator.getParameters().renameParameter(this.oldAttributeName, this.newAttributeName);
            return "Parameter <code>" + this.oldAttributeName + "</code> in <var>" + operator.getName() + "</var> (<code>" + operatorTypeName + "</code>) was renamed to <code>" + this.newAttributeName + "</code>.";
        }
        return null;
    }

    public String toString() {
        return "Replace " + this.operatorTypeName + "." + this.oldAttributeName + " by " + this.newAttributeName;
    }
}

