/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.rules;

import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.rules.AbstractConditionedParseRule;
import com.rapidminer.io.process.rules.ParseRule;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.XMLException;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReplaceOperatorRule
extends AbstractConditionedParseRule {
    private static final VersionNumber APPLIES_UNTIL = new VersionNumber(5, 0, 0, false, 0, false, 0);
    private String replacementName;
    private final List<ParseRule> parseRules = new LinkedList<ParseRule>();

    public ReplaceOperatorRule(String operatorTypeName, Element element) throws XMLException {
        super(operatorTypeName, element);
        assert (element.getTagName().equals("replaceOperator"));
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            if (childElement.getTagName().equals("replacement")) {
                this.replacementName = childElement.getTextContent();
                continue;
            }
            if (childElement.getTagName().equals("condition")) {
                this.parseCondition(childElement);
                continue;
            }
            this.parseRules.add(XMLImporter.constructRuleFromElement(operatorTypeName, childElement));
        }
    }

    @Override
    protected String conditionedApply(Operator operator, String operatorTypeName, XMLImporter importer) {
        OperatorChain parent = operator.getParent();
        int subprocess = 0;
        int operatorIndex = -1;
        for (subprocess = 0; subprocess < parent.getNumberOfSubprocesses(); ++subprocess) {
            int i = 0;
            for (Operator currentOperator : parent.getSubprocess(subprocess).getOperators()) {
                if (currentOperator == operator) {
                    operatorIndex = i;
                    break;
                }
                ++i;
            }
            if (operatorIndex > -1) break;
        }
        try {
            StringBuilder builder = new StringBuilder("Replaced operator <code>" + operatorTypeName + "</code> by <code>" + this.replacementName + "</code>.");
            if (!this.parseRules.isEmpty()) {
                builder.append(" In <code>" + this.replacementName + "</code>, the following modifications were applied:<ul>");
                for (ParseRule rule : this.parseRules) {
                    String result = rule.apply(operator, null, importer);
                    if (result == null) continue;
                    builder.append("<li>" + result + "</li>");
                }
                builder.append("</ul>");
            }
            Operator replacement = OperatorService.createOperator(this.replacementName);
            for (String key : operator.getParameters().getDefinedKeys()) {
                try {
                    replacement.setParameter(key, operator.getParameters().getParameter(key));
                }
                catch (UndefinedParameterError e) {}
            }
            operator.remove();
            replacement.rename(operator.getName());
            parent.getSubprocess(subprocess).addOperator(replacement, operatorIndex);
            if (operator instanceof OperatorChain) {
                OperatorChain oldChain = (OperatorChain)operator;
                OperatorChain newChain = (OperatorChain)replacement;
                for (int i = 0; i < oldChain.getNumberOfSubprocesses(); ++i) {
                    ExecutionUnit oldUnit = oldChain.getSubprocess(i);
                    ExecutionUnit newUnit = newChain.getSubprocess(i);
                    newUnit.stealOperatorsFrom(oldUnit);
                }
            }
            return builder.toString();
        }
        catch (OperatorCreationException e) {
            return "Failed to create replacement operator " + this.replacementName + " for deprecated " + operatorTypeName + ".";
        }
    }
}

