/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.rules;

import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.rules.AbstractGenericParseRule;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.IOMultiplier;
import com.rapidminer.operator.IOMultiplyOperator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public class ReplaceIOMultiplierRule
extends AbstractGenericParseRule {
    private static final VersionNumber APPLIES_UNTIL = new VersionNumber(5, 0, 0, false, 0, false, 0);

    @Override
    public String apply(final Operator oldMultiplier, VersionNumber processVersion, final XMLImporter importer) {
        if ((processVersion == null || processVersion.compareTo(APPLIES_UNTIL) < 0) && oldMultiplier.getClass().equals(IOMultiplyOperator.class)) {
            importer.doAfterAutoWire(new Runnable(){

                @Override
                public void run() {
                    int j;
                    int i;
                    int numOutports;
                    int count = 0;
                    ExecutionUnit unit = oldMultiplier.getExecutionUnit();
                    int oldIndex = unit.getOperators().indexOf(oldMultiplier);
                    try {
                        numOutports = oldMultiplier.getParameterAsInt("number_of_copies") + 1;
                    }
                    catch (UndefinedParameterError e) {
                        importer.addMessage("<div class=\"error\">Cannot replace <code>IOMultiplier</code>. Parameter <var>number_of_copies</var> is not set.</div>");
                        return;
                    }
                    OutputPort[] sources = new OutputPort[oldMultiplier.getInputPorts().getNumberOfPorts()];
                    InputPort[][] sinks = new InputPort[oldMultiplier.getInputPorts().getNumberOfPorts()][numOutports];
                    for (i = 0; i < sources.length; ++i) {
                        InputPort in = (InputPort)oldMultiplier.getInputPorts().getPortByIndex(i);
                        if (!in.isConnected()) continue;
                        sources[i] = in.getSource();
                        sources[i].lock();
                        for (j = 0; j < numOutports; ++j) {
                            sinks[i][j] = ((OutputPort)oldMultiplier.getOutputPorts().getPortByIndex(i * numOutports + j)).getDestination();
                            if (sinks[i][j] == null) continue;
                            sinks[i][j].lock();
                        }
                    }
                    oldMultiplier.remove();
                    for (i = 0; i < sources.length; ++i) {
                        try {
                            if (sources[i] == null) continue;
                            IOMultiplier newMultiplier = OperatorService.createOperator(IOMultiplier.class);
                            unit.addOperator((Operator)newMultiplier, oldIndex);
                            newMultiplier.rename(oldMultiplier.getName() + "_" + ++count);
                            sources[i].connectTo((InputPort)newMultiplier.getInputPorts().getPortByIndex(0));
                            for (j = 0; j < numOutports; ++j) {
                                if (sinks[i][j] == null) continue;
                                ((OutputPort)newMultiplier.getOutputPorts().getPortByIndex(j)).connectTo(sinks[i][j]);
                                sinks[i][j].unlock();
                            }
                            sources[i].unlock();
                            continue;
                        }
                        catch (OperatorCreationException e) {
                            importer.addMessage("<div class=\"error\">Cannot replace <code>IOMultiplier</code>. Cannot create <code>IOMultiplier2</code>.");
                            LogService.getRoot().log(Level.WARNING, "Cannot create IOMultiplier2: " + e, e);
                            return;
                        }
                    }
                    importer.addMessage("Replaced <code>IOMultiplier</code> '<var>" + oldMultiplier.getName() + "</var>' by " + count + " <code>IOMultiplier2</code>.");
                }
            });
        }
        return null;
    }

    @Override
    public List<String> getApplicableOperatorKeys() {
        return Collections.singletonList("iomultiplier");
    }
}

