/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.rules;

import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.rules.AbstractParseRule;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.io.IOContainerWriter;
import com.rapidminer.operator.io.IOObjectWriter;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.XMLException;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class ReplaceIOContainerWriter
extends AbstractParseRule {
    public ReplaceIOContainerWriter(Element element) throws XMLException {
        super("iocontainerwriter", element);
    }

    @Override
    protected String apply(final Operator operator, String operatorTypeName, final XMLImporter importer) {
        if (operator instanceof IOContainerWriter) {
            importer.doAfterAutoWire(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String filenameBase;
                    IOContainerWriter ioContainerWriter = (IOContainerWriter)operator;
                    try {
                        filenameBase = ioContainerWriter.getParameterAsString("filename");
                    }
                    catch (UndefinedParameterError e1) {
                        filenameBase = ioContainerWriter.getName();
                    }
                    int num = 0;
                    for (int i = 0; i < ioContainerWriter.getInputPorts().getNumberOfPorts(); ++i) {
                        InputPort input = (InputPort)ioContainerWriter.getInputPorts().getPortByIndex(i);
                        if (!input.isConnected()) continue;
                        OutputPort source = input.getSource();
                        input.lock();
                        source.lock();
                        try {
                            source.disconnect();
                            IOObjectWriter writer = OperatorService.createOperator(IOObjectWriter.class);
                            writer.setParameter("object_file", filenameBase + "_" + (i + 1));
                            source.connectTo((InputPort)writer.getInputPorts().getPortByIndex(0));
                            OutputPort output = (OutputPort)ioContainerWriter.getOutputPorts().getPortByIndex(i);
                            if (output.isConnected()) {
                                InputPort dest = output.getDestination();
                                output.lock();
                                dest.lock();
                                try {
                                    output.disconnect();
                                    ((OutputPort)writer.getOutputPorts().getPortByIndex(0)).connectTo(dest);
                                }
                                finally {
                                    output.unlock();
                                    dest.unlock();
                                }
                            }
                            ++num;
                            continue;
                        }
                        catch (Exception e) {
                            LogService.getRoot().log(Level.WARNING, "Cannot insert IOObjectWriter: " + e, e);
                            importer.addMessage("<em class=\"error\">Error while replacing " + ioContainerWriter.getName() + ": " + e + "</em>");
                            continue;
                        }
                        finally {
                            input.unlock();
                            source.unlock();
                        }
                    }
                    ioContainerWriter.remove();
                    importer.addMessage("Replaced <var>" + ioContainerWriter.getName() + "</var> (<code>" + ioContainerWriter.getOperatorDescription().getName() + "</code>) by " + num + " <code>IOObjectWriter</code>s</span>");
                }
            });
        }
        return null;
    }
}

