/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.rules;

import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.rules.AbstractGenericParseRule;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.SimpleOperatorChain;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import java.util.Collections;
import java.util.List;

public class PassthroughShortcutRule
extends AbstractGenericParseRule {
    private static final VersionNumber APPLIES_UNTIL = new VersionNumber(5, 0, 0, false, 0, false, 0);

    @Override
    public String apply(final Operator operator, VersionNumber processVersion, final XMLImporter importer) {
        if (operator.getClass().equals(SimpleOperatorChain.class) && (processVersion == null || processVersion.compareTo(APPLIES_UNTIL) < 0)) {
            importer.doAfterAutoWire(new Runnable(){

                @Override
                public void run() {
                    boolean found;
                    OperatorChain chain = (OperatorChain)operator;
                    InputPorts inputs = chain.getInputPorts();
                    OutputPorts sources = chain.getSubprocess(0).getInnerSources();
                    InputPorts sinks = chain.getSubprocess(0).getInnerSinks();
                    OutputPorts outputs = chain.getOutputPorts();
                    do {
                        found = false;
                        for (int leftIndex = 0; leftIndex < sources.getNumberOfPorts(); ++leftIndex) {
                            OutputPort source = (OutputPort)sources.getPortByIndex(leftIndex);
                            if (!source.isConnected()) continue;
                            InputPort sink = source.getDestination();
                            if (!sinks.getAllPorts().contains(sink)) continue;
                            int rightIndex = sinks.getAllPorts().indexOf(sink);
                            InputPort correspondingInput = (InputPort)inputs.getPortByIndex(leftIndex);
                            OutputPort correspondingOutput = (OutputPort)outputs.getPortByIndex(rightIndex);
                            if (!correspondingInput.isConnected() || !correspondingOutput.isConnected()) continue;
                            OutputPort originalSource = correspondingInput.getSource();
                            InputPort finalDestination = correspondingOutput.getDestination();
                            originalSource.lock();
                            finalDestination.lock();
                            originalSource.disconnect();
                            source.disconnect();
                            correspondingOutput.disconnect();
                            originalSource.connectTo(finalDestination);
                            originalSource.unlock();
                            finalDestination.unlock();
                            found = true;
                            importer.addMessage("The connection from <code>" + source.getSpec() + "</code> to <code>" + sink + "</code> was replaced by the direct connection from <code>" + originalSource.getSpec() + "</code> to <code>" + finalDestination.getSpec() + "</code>.");
                        }
                    } while (found);
                }
            });
        }
        return null;
    }

    @Override
    public List<String> getApplicableOperatorKeys() {
        return Collections.singletonList("subprocess");
    }
}

