/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.rules;

import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.rules.AbstractGenericParseRule;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.meta.OperatorEnabler;
import com.rapidminer.operator.meta.OperatorSelector;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import java.util.Collections;
import java.util.List;

public class OperatorEnablerRepairRule
extends AbstractGenericParseRule {
    private static final VersionNumber APPLIES_UNTIL = new VersionNumber(5, 0, 0, false, 0, false, 0);

    @Override
    public String apply(Operator operator, VersionNumber processVersion, XMLImporter importer) {
        if (operator.getClass().equals(OperatorEnabler.class) && (processVersion == null || processVersion.compareTo(APPLIES_UNTIL) < 0)) {
            OperatorSelector selector;
            String selectedName;
            OperatorEnabler enabler = (OperatorEnabler)operator;
            Operator selected = null;
            try {
                selectedName = enabler.getParameterAsString("operator_name");
            }
            catch (UndefinedParameterError e) {
                selectedName = null;
            }
            for (Operator op : enabler.getAllInnerOperators()) {
                if (!op.getName().equals(selectedName)) continue;
                selected = op;
                break;
            }
            try {
                selector = OperatorService.createOperator(OperatorSelector.class);
            }
            catch (OperatorCreationException e) {
                return "<em class=\"error\">The operator <var>" + enabler.getName() + "</var> (<code>OperatorEnabler</code>) could not be imported: " + e.getMessage() + "</em>";
            }
            int selectedSubprocess = enabler.getParameterAsBoolean("enable") ? 0 : 1;
            selector.setParameter("select_which", "" + (selectedSubprocess + 1));
            while (!enabler.getSubprocess(0).getOperators().isEmpty()) {
                Operator child = enabler.getSubprocess(0).getOperators().get(0);
                child.remove();
                selector.getSubprocess(0).addOperator(child.cloneOperator(null, false));
                if (child.getName().equals(selectedName)) continue;
                selector.getSubprocess(1).addOperator(child.cloneOperator(null, false));
            }
            ExecutionUnit parent = enabler.getExecutionUnit();
            int oldIndex = parent.getOperators().indexOf(enabler);
            enabler.remove();
            selector.rename(enabler.getName());
            parent.addOperator((Operator)selector, oldIndex);
            if (selected == null) {
                return "<em class=\"error\">The operator <var>" + enabler.getName() + "</var> (<code>OperatorEnabler</code>) could not be correctly imported since the enabled/disabled child '" + selectedName + "' was not found.</em>";
            }
            return "The operator <var>" + enabler.getName() + "</var> (<code>OperatorEnabler</code>) was replaced by an <code>OperatorSelector</code> where in subprocess " + selectedSubprocess + " the operator <var>" + selected.getName() + "</var> was omitted.";
        }
        return null;
    }

    @Override
    public List<String> getApplicableOperatorKeys() {
        return Collections.singletonList("operatorenabler");
    }
}

