/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.rules;

import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.io.process.rules.AbstractParseRule;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.tools.XMLException;
import java.util.LinkedList;
import org.w3c.dom.Element;

public class ExchangeSubprocessesRule
extends AbstractParseRule {
    private final int subprocess1;
    private final int subprocess2;

    public ExchangeSubprocessesRule(String operatorTypeName, Element element) throws XMLException {
        super(operatorTypeName, element);
        this.subprocess1 = Integer.parseInt(XMLTools.getTagContents(element, "subprocess1"));
        this.subprocess2 = Integer.parseInt(XMLTools.getTagContents(element, "subprocess2"));
    }

    @Override
    protected String apply(Operator operator, String operatorTypeName, XMLImporter importer) {
        OperatorChain chain = (OperatorChain)operator;
        ExecutionUnit unit1 = chain.getSubprocess(this.subprocess1);
        ExecutionUnit unit2 = chain.getSubprocess(this.subprocess2);
        LinkedList<Operator> ops1 = new LinkedList<Operator>(unit1.getOperators());
        LinkedList<Operator> ops2 = new LinkedList<Operator>(unit2.getOperators());
        for (Operator op : ops1) {
            op.remove();
        }
        for (Operator op : ops2) {
            op.remove();
        }
        for (Operator op : ops1) {
            unit2.addOperator(op);
        }
        for (Operator op : ops2) {
            unit1.addOperator(op);
        }
        return "Exchanged subprocesses " + (this.subprocess1 + 1) + " and " + (this.subprocess2 + 1) + " in <var>" + operator.getName() + "</var> (<code>" + operator.getOperatorDescription().getName() + "</code>)";
    }
}

