/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.rules;

import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.rules.AbstractConditionedParseRule;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExcelCellAddressParseRule
extends AbstractConditionedParseRule {
    private String parameterColumn;
    private String parameterRow;
    private String parameterAddress;

    public ExcelCellAddressParseRule(String operatorTypeName, Element element) throws XMLException {
        super(operatorTypeName, element);
        assert (element.getTagName().equals("replaceByCellAddress"));
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElem = (Element)child;
            if (childElem.getTagName().equals("columnParameter")) {
                this.parameterColumn = childElem.getTextContent();
                continue;
            }
            if (childElem.getTagName().equals("rowParameter")) {
                this.parameterRow = childElem.getTextContent();
                continue;
            }
            if (!childElem.getTagName().equals("addressParameter")) continue;
            this.parameterAddress = childElem.getTextContent();
        }
    }

    @Override
    protected String conditionedApply(Operator operator, String operatorTypeName, XMLImporter importer) {
        try {
            int column = operator.getParameterAsInt(this.parameterRow);
            int row = operator.getParameterAsInt(this.parameterColumn);
            operator.setParameter(this.parameterAddress, Tools.getExcelColumnName(column) + row);
            return "Replaced column and row offset by cell address parameter in <var>\"" + operator.getName() + "\"</var>.";
        }
        catch (UndefinedParameterError e) {
            return null;
        }
    }
}

