/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.rules;

import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.rules.AbstractGenericParseRule;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.SimpleOperatorChain;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DeleteUnnecessaryOperatorChainRule
extends AbstractGenericParseRule {
    private static final VersionNumber APPLIES_UNTIL = new VersionNumber(5, 0, 0, false, 0, false, 0);

    @Override
    public String apply(final Operator operator, VersionNumber processVersion, final XMLImporter importer) {
        if (operator.getClass() == SimpleOperatorChain.class && (processVersion == null || processVersion.compareTo(APPLIES_UNTIL) <= 0)) {
            importer.doAfterTreeConstruction(new Runnable(){

                @Override
                public void run() {
                    OperatorChain parent = operator.getParent();
                    if (parent != null) {
                        for (ExecutionUnit unit : parent.getSubprocesses()) {
                            Collection<Operator> innerOperators = unit.getChildOperators();
                            if (innerOperators.size() != 1 || innerOperators.iterator().next() != operator) continue;
                            importer.addMessage("<code>OperatorChain</code>s are unneccessary if they are the only operator inside a subprocess. Removed unnecessary OperatorChain <var>" + operator.getName() + "</var> in <var>" + parent.getName() + "</var>.");
                            OperatorChain self = (OperatorChain)operator;
                            for (Operator child : new LinkedList<Operator>(self.getSubprocess(0).getOperators())) {
                                child.remove();
                                unit.addOperator(child);
                            }
                            self.remove();
                        }
                    }
                }
            });
        }
        return null;
    }

    @Override
    public List<String> getApplicableOperatorKeys() {
        return Collections.singletonList("subprocess");
    }
}

