/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.rules;

import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.rules.AbstractConditionedParseRule;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.XMLException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChangeParameterValueRule
extends AbstractConditionedParseRule {
    private String attributeName;
    private String oldValue;
    private String newValue;

    public ChangeParameterValueRule(String operatorTypeName, Element element) throws XMLException {
        super(operatorTypeName, element);
        assert (element.getTagName().equals("setParameter"));
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElem = (Element)child;
            if (childElem.getTagName().equals("parameter")) {
                this.attributeName = childElem.getTextContent();
                continue;
            }
            if (childElem.getTagName().equals("oldvalue")) {
                this.oldValue = childElem.getTextContent();
                continue;
            }
            if (!childElem.getTagName().equals("newvalue")) continue;
            this.newValue = childElem.getTextContent();
        }
    }

    @Override
    protected String conditionedApply(Operator operator, String operatorTypeName, XMLImporter importer) {
        String value;
        if (operator.getParameters().isSpecified(this.attributeName) && this.oldValue.equals(value = operator.getParameters().getParameterOrNull(this.attributeName))) {
            operator.getParameters().setParameter(this.attributeName, this.newValue);
            return "The value of the parameter <code>" + this.attributeName + "</code> in <var>" + operator.getName() + "</var> (<code>" + operatorTypeName + "</code>) was changed from " + value + " to <code>" + this.newValue + "</code>.";
        }
        return null;
    }

    public String toString() {
        return "Set " + this.operatorTypeName + "." + this.attributeName + " to " + this.oldValue;
    }
}

