/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.rules;

import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.rules.ParseRule;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.XMLException;
import org.w3c.dom.Element;

public abstract class AbstractParseRule
implements ParseRule {
    private static final String APPLIES_BEFORE_VERSION = "appliesBefore";
    private static final String APPLIES_SINCE_VERSION = "appliesSince";
    private static final String APPLIES_BEFORE_VERSION_DEFAULT = "5.0.000";
    private static final String APPLIES_SINCE_VERSION_DEFAULT = "1.0.000";
    protected String operatorTypeName;
    protected VersionNumber appliesBefore;
    protected VersionNumber appliesSince;

    public AbstractParseRule(String operatorTypeName, Element element) throws XMLException {
        this.operatorTypeName = operatorTypeName;
        String beforeVersion = element.getAttribute(APPLIES_BEFORE_VERSION);
        String afterVersion = element.getAttribute(APPLIES_SINCE_VERSION);
        if (beforeVersion.isEmpty()) {
            beforeVersion = APPLIES_BEFORE_VERSION_DEFAULT;
        }
        if (afterVersion.isEmpty()) {
            afterVersion = APPLIES_SINCE_VERSION_DEFAULT;
        }
        this.appliesBefore = new VersionNumber(beforeVersion);
        this.appliesSince = new VersionNumber(afterVersion);
    }

    @Override
    public String apply(Operator operator, VersionNumber processVersion, XMLImporter importer) {
        if (operator.getOperatorDescription().getKey().equals(this.operatorTypeName) && (processVersion == null || processVersion.compareTo(this.appliesSince) >= 0 && processVersion.compareTo(this.appliesBefore) < 0)) {
            return this.apply(operator, this.operatorTypeName, importer);
        }
        return null;
    }

    protected abstract String apply(Operator var1, String var2, XMLImporter var3);
}

