/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.rules;

import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.conditions.ParameterEqualsCondition;
import com.rapidminer.io.process.conditions.ParameterUnequalsCondition;
import com.rapidminer.io.process.conditions.ParseRuleCondition;
import com.rapidminer.io.process.rules.AbstractParseRule;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.XMLException;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractConditionedParseRule
extends AbstractParseRule {
    private final List<ParseRuleCondition> conditions = new LinkedList<ParseRuleCondition>();

    public AbstractConditionedParseRule(String operatorTypeName, Element element) throws XMLException {
        super(operatorTypeName, element);
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElem;
            Node child = children.item(i);
            if (!(child instanceof Element) || !(childElem = (Element)child).getTagName().equals("condition")) continue;
            this.parseCondition(childElem);
        }
    }

    protected void parseCondition(Element childElem) {
        NodeList conditionNodes = childElem.getChildNodes();
        for (int j = 0; j < conditionNodes.getLength(); ++j) {
            Node conditionNode = conditionNodes.item(j);
            if (!(conditionNode instanceof Element)) continue;
            Element conditionElem = (Element)conditionNode;
            if (conditionElem.getTagName().equals("parameter_equals")) {
                this.conditions.add(new ParameterEqualsCondition((Element)conditionNode));
                continue;
            }
            if (conditionElem.getTagName().equals("parameter_unequals")) {
                this.conditions.add(new ParameterUnequalsCondition((Element)conditionNode));
                continue;
            }
            LogService.getRoot().warning("Unknown condition: " + conditionElem.getTagName());
        }
    }

    @Override
    protected String apply(Operator operator, String operatorTypeName, XMLImporter importer) {
        for (ParseRuleCondition condition : this.conditions) {
            if (condition.isSatisfied(operator)) continue;
            return null;
        }
        return this.conditionedApply(operator, operatorTypeName, importer);
    }

    protected abstract String conditionedApply(Operator var1, String var2, XMLImporter var3);
}

