/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process.conditions;

import com.rapidminer.io.process.conditions.ParseRuleCondition;
import com.rapidminer.operator.Operator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParameterEqualsCondition
implements ParseRuleCondition {
    protected String parameterKey;
    protected String parameterValue;

    public ParameterEqualsCondition(Element element) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElem = (Element)child;
            if (childElem.getTagName().equals("parameter")) {
                this.parameterKey = childElem.getTextContent();
                continue;
            }
            if (!childElem.getTagName().equals("value")) continue;
            this.parameterValue = childElem.getTextContent();
        }
    }

    @Override
    public boolean isSatisfied(Operator operator) {
        if (this.parameterValue.equals("")) {
            return !operator.getParameters().isSpecified(this.parameterKey) || operator.getParameters().getParameterAsSpecified(this.parameterKey).equals(this.parameterValue);
        }
        return operator.getParameters().isSpecified(this.parameterKey) && operator.getParameters().getParameterAsSpecified(this.parameterKey).equals(this.parameterValue);
    }

    public String toString() {
        return this.parameterKey + "='" + this.parameterValue + "'";
    }
}

