/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process;

import com.rapidminer.io.process.XMLErrorHandler;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.XMLException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLTools {
    private static final Map<URI, Validator> VALIDATORS;
    private static final DocumentBuilder BUILDER;
    public static final String SCHEMA_URL_PROCESS = "http://www.rapidminer.com/xml/schema/RapidMinerProcess";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Validator getValidator(URI schemaURI) {
        if (schemaURI == null) {
            throw new NullPointerException("SchemaURL is null!");
        }
        Map<URI, Validator> map = VALIDATORS;
        synchronized (map) {
            Validator validator;
            if (VALIDATORS.containsKey(schemaURI)) {
                return VALIDATORS.get(schemaURI);
            }
            SchemaFactory factory = null;
            if (factory == null) {
                throw new RuntimeException("XMLConstants.W3C_XML_SCHEMA_NS_URI cannot be resolved at compile time for JBoss.");
            }
            try {
                validator = factory.newSchema(schemaURI.toURL()).newValidator();
            }
            catch (SAXException e1) {
                validator = null;
            }
            catch (MalformedURLException e) {
                validator = null;
            }
            VALIDATORS.put(schemaURI, validator);
            return validator;
        }
    }

    public static Document parseAndValidate(InputStream in, URL schemaURL, String sourceName) throws XMLException, IOException {
        try {
            return XMLTools.parseAndValidate(in, new URI(schemaURL.toString()), sourceName);
        }
        catch (URISyntaxException e) {
            throw new XMLException("Could not resolve URL.", e);
        }
    }

    public static Document parseAndValidate(InputStream in, URI schemaURL, String sourceName) throws XMLException, IOException {
        Document doc;
        XMLErrorHandler errorHandler = new XMLErrorHandler(sourceName);
        try {
            doc = BUILDER.parse(in);
        }
        catch (SAXException e) {
            throw new XMLException(errorHandler.toString(), e);
        }
        DOMSource source = new DOMSource(doc);
        DOMResult result = new DOMResult();
        Validator validator = XMLTools.getValidator(schemaURL);
        validator.setErrorHandler(errorHandler);
        try {
            validator.validate(source, result);
        }
        catch (SAXException e) {
            throw new XMLException(errorHandler.toString(), e);
        }
        if (errorHandler.hasErrors()) {
            throw new XMLException(errorHandler.toString());
        }
        return (Document)result.getNode();
    }

    public static Document parse(String string) throws SAXException, IOException {
        return BUILDER.parse(new ByteArrayInputStream(string.getBytes(Charset.forName("UTF-8"))));
    }

    public static Document parse(InputStream in) throws SAXException, IOException {
        return BUILDER.parse(in);
    }

    public static Document parse(File file) throws SAXException, IOException {
        return BUILDER.parse(file);
    }

    public static String toString(Document document, Charset encoding) throws XMLException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(new OutputStreamWriter(buf));
        XMLTools.stream(document, result, encoding);
        return buf.toString();
    }

    public static void stream(Document document, File file, Charset encoding) throws XMLException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            XMLTools.stream(document, out, encoding);
        }
        catch (IOException e) {
            throw new XMLException("Cannot save XML to " + file + ": " + e, e);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void stream(Document document, OutputStream out, Charset encoding) throws XMLException {
        if (encoding == null) {
            encoding = Charset.forName("UTF-8");
        }
        XMLTools.stream(document, new StreamResult(new OutputStreamWriter(out, encoding)), encoding);
    }

    public static void stream(Document document, Result result, Charset encoding) throws XMLException {
        Transformer transformer;
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                tf.setAttribute("indent-number", 2);
            }
            catch (IllegalArgumentException e) {
                LogService.getRoot().log(Level.WARNING, "XML transformer does not support indentation: " + e);
            }
            transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding.name());
            }
        }
        catch (TransformerConfigurationException e) {
            throw new XMLException("Cannot transform XML: " + e, e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new XMLException("Cannot transform XML: " + e, e);
        }
        try {
            transformer.transform(new DOMSource(document), result);
        }
        catch (TransformerException e) {
            throw new XMLException("Cannot transform XML: " + e, e);
        }
    }

    public static String getTagContents(Element element, String tag) {
        try {
            return XMLTools.getTagContents(element, tag, false);
        }
        catch (XMLException e) {
            return null;
        }
    }

    public static String getTagContents(Element parent, String tagName, boolean throwExceptionOnError) throws XMLException {
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !((Element)node).getTagName().equals(tagName)) continue;
            Element child = (Element)node;
            return child.getTextContent();
        }
        if (throwExceptionOnError) {
            throw new XMLException("Missing tag: <" + tagName + "> in <" + parent.getTagName() + ">.");
        }
        return null;
    }

    public static int getTagContentsAsInt(Element element, String tag) throws XMLException {
        String string = XMLTools.getTagContents(element, tag, true);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw new XMLException("Contents of tag <" + tag + "> must be integer, but found '" + string + "'.");
        }
    }

    public static boolean getTagContentsAsBoolean(Element parent, String tagName, boolean dflt) throws XMLException {
        String string = XMLTools.getTagContents(parent, tagName, false);
        if (string == null) {
            return dflt;
        }
        try {
            return Boolean.parseBoolean(string);
        }
        catch (NumberFormatException e) {
            throw new XMLException("Contents of tag <" + tagName + "> must be true or false, but found '" + string + "'.");
        }
    }

    public static void setTagContents(Element parent, String tagName, String value) {
        if (value == null) {
            value = "";
        }
        Node child = null;
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element) || !((Element)node).getTagName().equals(tagName)) continue;
            child = (Element)node;
            break;
        }
        if (child == null) {
            child = parent.getOwnerDocument().createElement(tagName);
            parent.appendChild(child);
        } else {
            while (child.hasChildNodes()) {
                child.removeChild(child.getFirstChild());
            }
        }
        child.appendChild(parent.getOwnerDocument().createTextNode(value));
    }

    public static void deleteTagContents(Element parentElement, String name) {
        NodeList children = parentElement.getElementsByTagName(name);
        for (int i = 0; i < children.getLength(); ++i) {
            Element child = (Element)children.item(i);
            parentElement.removeChild(child);
        }
    }

    public static XMLGregorianCalendar getXMLGregorianCalendar(Date date) {
        DatatypeFactory datatypeFactory;
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Failed to create XMLGregorianCalendar: " + e, e);
        }
        XMLGregorianCalendar xmlGregorianCalendar = datatypeFactory.newXMLGregorianCalendar();
        xmlGregorianCalendar.setYear(calendar.get(1));
        xmlGregorianCalendar.setMonth(calendar.get(2) + 1);
        xmlGregorianCalendar.setDay(calendar.get(5));
        xmlGregorianCalendar.setHour(calendar.get(11));
        xmlGregorianCalendar.setMinute(calendar.get(12));
        xmlGregorianCalendar.setSecond(calendar.get(13));
        xmlGregorianCalendar.setMillisecond(calendar.get(14));
        return xmlGregorianCalendar;
    }

    public static Element getUniqueInnerTag(Element element, String tagName) throws XMLException {
        return XMLTools.getUniqueInnerTag(element, tagName, true);
    }

    public static Element getUniqueInnerTag(Element element, String tagName, boolean obligatory) throws XMLException {
        NodeList children = element.getElementsByTagName(tagName);
        switch (children.getLength()) {
            case 0: {
                if (obligatory) {
                    throw new XMLException("Missing inner tag <" + tagName + "> inside <" + element.getTagName() + ">.");
                }
                return null;
            }
            case 1: {
                return (Element)children.item(0);
            }
        }
        throw new XMLException("Inner tag <" + tagName + "> inside <" + element.getTagName() + "> must be unique, but found " + children.getLength() + ".");
    }

    public static Collection<Element> getChildElements(Element father, String tagName) {
        LinkedList<Element> elements = new LinkedList<Element>();
        NodeList list = father.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals(tagName)) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    public static Element getChildElement(Element father, String tagName, boolean mandatory) throws XMLException {
        Collection<Element> children = XMLTools.getChildElements(father, tagName);
        switch (children.size()) {
            case 0: {
                if (mandatory) {
                    throw new XMLException("Missing child tag <" + tagName + "> inside <" + father.getTagName() + ">.");
                }
                return null;
            }
            case 1: {
                return children.iterator().next();
            }
        }
        throw new XMLException("Child tag <" + tagName + "> inside <" + father.getTagName() + "> must be unique, but found " + children.size() + ".");
    }

    public static void addTag(Element parent, String name, String textValue) {
        Element child = parent.getOwnerDocument().createElement(name);
        child.setTextContent(textValue);
        parent.appendChild(child);
    }

    public static Document createDocument() {
        return BUILDER.newDocument();
    }

    public static Element addTag(Element fatherElement, String tagName) {
        Element createElement = fatherElement.getOwnerDocument().createElement(tagName);
        fatherElement.appendChild(createElement);
        return createElement;
    }

    public static Element getChildTag(Element element, String xmlTagName, boolean optional) throws XMLException {
        NodeList children = element.getChildNodes();
        Element found = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!(n instanceof Element) || !((Element)n).getTagName().equals(xmlTagName)) continue;
            if (found != null) {
                throw new XMLException("Tag <" + xmlTagName + "> in <" + element.getTagName() + "> must be unique.");
            }
            found = (Element)n;
        }
        if (!optional && found == null) {
            throw new XMLException("Tag <" + xmlTagName + "> in <" + element.getTagName() + "> is missing.");
        }
        return found;
    }

    static {
        DocumentBuilder builder;
        VALIDATORS = new HashMap<URI, Validator>();
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        try {
            builder = domFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            builder = null;
        }
        BUILDER = builder;
    }
}

