/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process;

import com.rapidminer.BreakpointListener;
import com.rapidminer.Process;
import com.rapidminer.ProcessContext;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.io.process.ProcessXMLFilterRegistry;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.io.process.rules.AbstractGenericParseRule;
import com.rapidminer.io.process.rules.AbstractParseRule;
import com.rapidminer.io.process.rules.ChangeParameterValueRule;
import com.rapidminer.io.process.rules.DeleteAfterAutoWireRule;
import com.rapidminer.io.process.rules.DeleteUnnecessaryOperatorChainRule;
import com.rapidminer.io.process.rules.ExcelCellAddressParseRule;
import com.rapidminer.io.process.rules.ExchangeSubprocessesRule;
import com.rapidminer.io.process.rules.OperatorEnablerRepairRule;
import com.rapidminer.io.process.rules.ParseRule;
import com.rapidminer.io.process.rules.PassthroughShortcutRule;
import com.rapidminer.io.process.rules.RenamePlotterParametersRule;
import com.rapidminer.io.process.rules.ReplaceIOContainerWriter;
import com.rapidminer.io.process.rules.ReplaceIOMultiplierRule;
import com.rapidminer.io.process.rules.ReplaceOperatorRule;
import com.rapidminer.io.process.rules.ReplaceParameterRule;
import com.rapidminer.io.process.rules.SetParameterRule;
import com.rapidminer.io.process.rules.SetRoleByNameRule;
import com.rapidminer.io.process.rules.SwitchListEntriesRule;
import com.rapidminer.io.process.rules.WireAllOperators;
import com.rapidminer.operator.DummyOperator;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.ListDescription;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorVersion;
import com.rapidminer.operator.ProcessRootOperator;
import com.rapidminer.operator.UnknownParameterInformation;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.PortException;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.container.Pair;
import com.rapidminer.tools.plugin.Plugin;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLImporter {
    public static final VersionNumber VERSION_RM_3 = new VersionNumber(3, 0);
    public static final VersionNumber VERSION_RM_4 = new VersionNumber(4, 0);
    public static final VersionNumber VERSION_RM_5;
    public static final VersionNumber CURRENT_VERSION;
    private static final Set<String> IRRELEVANT_PARAMETERS;
    public static final Charset PROCESS_FILE_CHARSET;
    private static List<ParseRule> PARSE_RULES;
    private static HashMap<String, List<ParseRule>> OPERATOR_KEY_RULES_MAP;
    private final List<Runnable> jobsAfterAutoWire = new LinkedList<Runnable>();
    private final List<Runnable> jobsAfterTreeConstruction = new LinkedList<Runnable>();
    private boolean mustAutoConnect = false;
    private int total;
    private final ProgressListener progressListener;
    private int created = 0;
    private final StringBuilder messages = new StringBuilder();
    private boolean operatorAsDirectChildrenDeprecatedReported = false;
    private int messageCount = 0;

    public static void init() {
        URL rulesResource = XMLImporter.class.getResource("/com/rapidminer/resources/parserules.xml");
        if (rulesResource != null) {
            XMLImporter.importParseRules(rulesResource, null);
        } else {
            LogService.getRoot().warning("Cannot find default parse rules.");
        }
    }

    public static void importParseRules(URL rulesResource, Plugin prover) {
        if (rulesResource == null) {
            throw new NullPointerException("Parserules resource must not be null.");
        }
        String operatorNamePrefix = "";
        if (prover != null) {
            operatorNamePrefix = prover.getPrefix() + ":";
        }
        LogService.getRoot().config("Reading parse rules from " + rulesResource);
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(rulesResource.openStream());
            if (!doc.getDocumentElement().getTagName().equals("parserules")) {
                LogService.getRoot().log(Level.SEVERE, "XML document " + rulesResource + " does not start with <parserules>");
            } else {
                NodeList operatorElements = doc.getDocumentElement().getChildNodes();
                for (int i = 0; i < operatorElements.getLength(); ++i) {
                    if (!(operatorElements.item(i) instanceof Element)) continue;
                    Element operatorElement = (Element)operatorElements.item(i);
                    String operatorTypeName = operatorElement.getNodeName();
                    NodeList ruleElements = operatorElement.getChildNodes();
                    for (int j = 0; j < ruleElements.getLength(); ++j) {
                        if (!(ruleElements.item(j) instanceof Element)) continue;
                        PARSE_RULES.add(XMLImporter.constructRuleFromElement(operatorNamePrefix + operatorTypeName, (Element)ruleElements.item(j)));
                    }
                }
                LogService.getRoot().fine("Found " + PARSE_RULES.size() + " rules are.");
            }
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.SEVERE, "Error reading parse rules from " + rulesResource + ": " + e, e);
        }
    }

    public static ParseRule constructRuleFromElement(String operatorTypeName, Element element) throws XMLException {
        AbstractParseRule rule = null;
        AbstractGenericParseRule genericRule = null;
        if (element.getTagName().equals("replaceParameter")) {
            rule = new ReplaceParameterRule(operatorTypeName, element);
        } else if (element.getTagName().equals("deleteAfterAutowire")) {
            rule = new DeleteAfterAutoWireRule(operatorTypeName, element);
        } else if (element.getTagName().equals("setParameter")) {
            rule = new SetParameterRule(operatorTypeName, element);
        } else if (element.getTagName().equals("replaceParameterValue")) {
            rule = new ChangeParameterValueRule(operatorTypeName, element);
        } else if (element.getTagName().equals("replaceOperator")) {
            rule = new ReplaceOperatorRule(operatorTypeName, element);
        } else if (element.getTagName().equals("exchangeSubprocesses")) {
            rule = new ExchangeSubprocessesRule(operatorTypeName, element);
        } else if (element.getTagName().equals("wireSubprocess")) {
            rule = new WireAllOperators(operatorTypeName, element);
        } else if (element.getTagName().equals("switchListEntries")) {
            rule = new SwitchListEntriesRule(operatorTypeName, element);
        } else if (element.getTagName().equals("renamePlotterParameters")) {
            rule = new RenamePlotterParametersRule(operatorTypeName, element);
        } else if (element.getTagName().equals("replaceRoleParameter")) {
            rule = new SetRoleByNameRule(operatorTypeName, element);
        } else if (element.getTagName().equals("replaceByCellAddress")) {
            rule = new ExcelCellAddressParseRule(operatorTypeName, element);
        } else if (element.getTagName().equals("deleteUnnecessaryOperatorChain")) {
            genericRule = new DeleteUnnecessaryOperatorChainRule();
        } else if (element.getTagName().equals("replaceIOContainerWriter")) {
            rule = new ReplaceIOContainerWriter(element);
            operatorTypeName = "iocontainerwriter";
        } else if (element.getTagName().equals("passthroughShortcut")) {
            genericRule = new PassthroughShortcutRule();
        } else if (element.getTagName().equals("replaceIOMultiplier")) {
            genericRule = new ReplaceIOMultiplierRule();
        } else if (element.getTagName().equals("repairOperatorEnabler")) {
            genericRule = new OperatorEnablerRepairRule();
        } else {
            throw new XMLException("Unknown rule tag: <" + element.getTagName() + ">");
        }
        if (rule != null) {
            List<ParseRule> rules = OPERATOR_KEY_RULES_MAP.get(operatorTypeName);
            if (rules == null) {
                rules = new LinkedList<ParseRule>();
                OPERATOR_KEY_RULES_MAP.put(operatorTypeName, rules);
            }
            rules.add(rule);
        }
        if (genericRule != null) {
            for (String applicableOperatorKeys : genericRule.getApplicableOperatorKeys()) {
                List<ParseRule> rules = OPERATOR_KEY_RULES_MAP.get(applicableOperatorKeys);
                if (rules == null) {
                    rules = new LinkedList<ParseRule>();
                    OPERATOR_KEY_RULES_MAP.put(applicableOperatorKeys, rules);
                }
                rules.add(genericRule);
            }
        }
        return rule;
    }

    public XMLImporter(ProgressListener listener) {
        this.progressListener = listener;
    }

    @Deprecated
    public XMLImporter(ProgressListener listener, int version) {
        this(listener);
    }

    public void addMessage(String msg) {
        LogService.getRoot().info(msg);
        ++this.messageCount;
        this.messages.append("<li>");
        this.messages.append(msg);
        this.messages.append("</li>");
    }

    public void parse(Document doc, Process process, List<UnknownParameterInformation> unknownParameters) throws XMLException {
        VersionNumber processVersion = this.parseVersion(doc.getDocumentElement());
        Element rootOperatorElement = this.getRootOperatorElement(doc);
        ProcessRootOperator rootOperator = this.parseRootOperator(rootOperatorElement, processVersion, process, unknownParameters);
        process.setRootOperator(rootOperator);
        NodeList contextElems = doc.getDocumentElement().getElementsByTagName("context");
        switch (contextElems.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                this.parseContext((Element)contextElems.item(0), process);
                break;
            }
            default: {
                this.addMessage("&lt;process&gt; can have at most one &lt;context&gt; tag.");
            }
        }
        NodeList annotationsElems = doc.getDocumentElement().getElementsByTagName("annotations");
        switch (annotationsElems.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                process.getAnnotations().parseXML((Element)annotationsElems.item(0));
                break;
            }
            default: {
                this.addMessage("&lt;process&gt; can have at most one &lt;annotations&gt; tag.");
            }
        }
        if (this.hasMessage()) {
            process.setImportMessage(this.getMessage());
        }
    }

    private ProcessRootOperator parseRootOperator(Element rootOperatorElement, VersionNumber processFileVersion, Process process, List<UnknownParameterInformation> unknownParameters) throws XMLException {
        Operator rootOp = this.parseOperator(rootOperatorElement, processFileVersion, process, unknownParameters);
        for (Runnable runnable : this.jobsAfterTreeConstruction) {
            runnable.run();
        }
        if (this.mustAutoConnect && rootOp instanceof OperatorChain) {
            try {
                ((OperatorChain)rootOp).getSubprocess(0).autoWire(CompatibilityLevel.PRE_VERSION_5, true, true);
                this.addMessage("As of version 5.0, RapidMiner processes define an explicit data flow. This data flow has been constructed automatically.");
            }
            catch (Exception e) {
                this.addMessage("As of version 5.0, RapidMiner processes define an explicit data flow. This data flow could not be constructed automatically: " + e);
                LogService.getRoot().log(Level.WARNING, "Cannot autowire: " + e, e);
            }
        }
        for (Runnable runnable : this.jobsAfterAutoWire) {
            runnable.run();
        }
        if (rootOp instanceof ProcessRootOperator) {
            return (ProcessRootOperator)rootOp;
        }
        throw new XMLException("Outermost operator must be of type 'Process' (<operator class=\"Process\">)");
    }

    private Element getRootOperatorElement(Document document) throws XMLException {
        Element documentElement = document.getDocumentElement();
        Element rootOperatorElement = null;
        if ("process".equals(documentElement.getTagName()) || "experiment".equals(documentElement.getTagName())) {
            NodeList children = documentElement.getChildNodes();
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Element childElement;
                Node childNode = children.item(i);
                if (!(childNode instanceof Element) || !(childElement = (Element)childNode).getTagName().equals("operator")) continue;
                rootOperatorElement = childElement;
                break;
            }
            if (rootOperatorElement == null) {
                throw new XMLException("The <process> tag must contain exactly one inner operator of type 'Process'!");
            }
        } else if ("operator".equals(documentElement.getTagName())) {
            rootOperatorElement = documentElement;
        } else {
            throw new XMLException("Root element must be one out of <process>, <experiment>, or <operator>.");
        }
        return rootOperatorElement;
    }

    private void parseProcess(Element element, ExecutionUnit executionUnit, VersionNumber processFileVersion, Process process, List<UnknownParameterInformation> unknownParameterInformation) throws XMLException {
        assert ("process".equals(element.getTagName()));
        if (element.hasAttribute("expanded")) {
            String expansionString = element.getAttribute("expanded");
            if ("no".equals(expansionString) || "false".equals(expansionString)) {
                executionUnit.setExpanded(false);
            } else if ("yes".equals(expansionString) || "true".equals(expansionString)) {
                executionUnit.setExpanded(true);
            } else {
                throw new XMLException("Expansion mode `" + expansionString + "` is not defined!");
            }
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element opElement = (Element)child;
            if ("operator".equals(opElement.getTagName())) {
                this.parseOperator(opElement, executionUnit, processFileVersion, process, unknownParameterInformation);
                continue;
            }
            if ("connect".equals(opElement.getTagName())) {
                this.parseConnection(opElement, executionUnit);
                continue;
            }
            if ("portSpacing".equals(opElement.getTagName())) continue;
            this.addMessage("<em class=\"error\">ExecutionUnit must only contain <operator> tags as children. Ignoring unknown tag <code>&lt;" + opElement.getTagName() + "&gt;</code>.</em>");
        }
        ProcessXMLFilterRegistry.fireExecutionUnitImported(executionUnit, element);
    }

    private void parseConnection(Element connectionElement, ExecutionUnit executionUnit) throws XMLException {
        InputPorts inputPorts;
        OutputPorts outputPorts;
        if (connectionElement.hasAttribute("from_op")) {
            String fromOp = connectionElement.getAttribute("from_op");
            Operator from = executionUnit.getOperatorByName(fromOp);
            if (from == null) {
                this.addMessage("<em class=\"error\">Unkown operator " + fromOp + " referenced in <code>from_op</code>.</em>");
                return;
            }
            outputPorts = from.getOutputPorts();
        } else {
            outputPorts = executionUnit.getInnerSources();
        }
        String fromPort = connectionElement.getAttribute("from_port");
        OutputPort out = (OutputPort)outputPorts.getPortByName(fromPort);
        if (out == null) {
            this.addMessage("<em class=\"error\">The output port <var>" + fromPort + "</var> is unknown at operator <var>" + outputPorts.getOwner().getName() + "</var>.</em>");
            return;
        }
        if (connectionElement.hasAttribute("to_op")) {
            String toOp = connectionElement.getAttribute("to_op");
            Operator to = executionUnit.getOperatorByName(toOp);
            if (to == null) {
                this.addMessage("<em class=\"error\">Unkown operator " + toOp + " referenced in <code>to_op</code>.</em>");
                return;
            }
            inputPorts = to.getInputPorts();
        } else {
            inputPorts = executionUnit.getInnerSinks();
        }
        String toPort = connectionElement.getAttribute("to_port");
        InputPort in = (InputPort)inputPorts.getPortByName(toPort);
        if (in == null) {
            this.addMessage("<em class=\"error\">The input port <var>" + toPort + "</var> is unknown at operator <var>" + inputPorts.getOwner().getName() + "</var>.</em>");
            return;
        }
        try {
            out.connectTo(in);
        }
        catch (PortException e) {
            this.addMessage("<em class=\"error\">Faild to connect ports: " + e.getMessage() + "</var>.</em>");
        }
    }

    public Operator parseOperator(Element opElement, VersionNumber processVersion, Process process, List<UnknownParameterInformation> unknownParameterInformation) throws XMLException {
        this.total = opElement.getElementsByTagName("operator").getLength();
        Operator operator = this.parseOperator(opElement, null, processVersion, process, unknownParameterInformation);
        this.unlockPorts(operator);
        return operator;
    }

    private Operator parseOperator(Element opElement, ExecutionUnit addToProcess, VersionNumber processFileVersion, Process process, List<UnknownParameterInformation> unknownParameterInformation) throws XMLException {
        String key;
        List<ParseRule> list;
        OperatorVersion latest;
        int i;
        OperatorVersion opVersion;
        Operator operator;
        String className;
        block57: {
            OperatorDescription opDescr;
            assert ("operator".equals(opElement.getTagName()));
            className = opElement.getAttribute("class");
            String replacement = OperatorService.getReplacementForDeprecatedClass(className);
            if (replacement != null) {
                this.addMessage("Deprecated operator '<code>" + className + "</code>' was replaced by '<code>" + replacement + "</code>'.");
                className = replacement;
            }
            if ((opDescr = OperatorService.getOperatorDescription(className)) == null) {
                OperatorDescription[] operatorDescriptions = OperatorService.getOperatorDescriptions(DummyOperator.class);
                if (operatorDescriptions.length == 1) {
                    opDescr = operatorDescriptions[0];
                    if (className.indexOf(58) == -1) {
                        this.addMessage("<em class=\"error\">The operator class '" + className + "' is unknown.</em>");
                    } else {
                        this.addMessage("<em class=\"error\">The operator class '" + className + "' is unknown. Possibly you must install a plugin for operators of group '" + className.substring(0, className.indexOf(58)) + "'.</em>");
                    }
                } else {
                    throw new XMLException("Unknown operator class: '" + className + "'!");
                }
            }
            try {
                operator = opDescr.createOperatorInstance();
                if (operator instanceof DummyOperator) {
                    ((DummyOperator)operator).setReplaces(className);
                }
                ProcessXMLFilterRegistry.fireOperatorImported(operator, opElement);
                ++this.created;
                if (this.progressListener != null && this.total > 0) {
                    this.progressListener.setCompleted(100 * this.created / this.total);
                }
            }
            catch (OperatorCreationException e) {
                throw new XMLException("Cannot create operator: " + e.getMessage(), e);
            }
            operator.rename(opElement.getAttribute("name"));
            String versionString = opElement.getAttribute("compatibility");
            if (versionString != null && !versionString.isEmpty()) {
                try {
                    opVersion = new OperatorVersion(versionString);
                    OperatorVersion[] incompatibleVersionChanges = operator.getIncompatibleVersionChanges();
                    OperatorVersion nextIncompatibility = null;
                    for (i = incompatibleVersionChanges.length - 1; i >= 0 && opVersion.isAtMost(incompatibleVersionChanges[i]); --i) {
                        nextIncompatibility = incompatibleVersionChanges[i];
                    }
                    if (nextIncompatibility == null) {
                        opVersion = OperatorVersion.getLatestVersion(opDescr);
                        break block57;
                    }
                    opVersion = nextIncompatibility;
                }
                catch (IllegalArgumentException e) {
                    this.addMessage("Failed to parse version string '" + versionString + "' for operator " + operator.getName() + ".");
                    opVersion = new OperatorVersion(5, 0, 0);
                }
            } else {
                opVersion = new OperatorVersion(5, 0, 0);
            }
        }
        operator.setCompatibilityLevel(opVersion);
        OperatorVersion[] incompatibleVersions = operator.getIncompatibleVersionChanges();
        if (incompatibleVersions != null && incompatibleVersions.length > 0 && (latest = incompatibleVersions[incompatibleVersions.length - 1]).compareTo(opVersion) > 0) {
            this.addMessage("Operator '" + operator.getName() + "' was created with version '" + opVersion + "'. The operator's behaviour has changed as of version and can be adapted to the latest version in the parameter panel.");
        }
        if (opElement.hasAttribute("breakpoints")) {
            String breakpointString = opElement.getAttribute("breakpoints");
            boolean ok = false;
            if (breakpointString.equals("both")) {
                operator.setBreakpoint(0, true);
                operator.setBreakpoint(1, true);
                ok = true;
            }
            for (int i2 = 0; i2 < BreakpointListener.BREAKPOINT_POS_NAME.length; ++i2) {
                if (breakpointString.indexOf(BreakpointListener.BREAKPOINT_POS_NAME[i2]) < 0) continue;
                operator.setBreakpoint(i2, true);
                ok = true;
            }
            if (!ok) {
                throw new XMLException("Breakpoint `" + breakpointString + "` is not defined!");
            }
        }
        if (opElement.hasAttribute("activated")) {
            String activationString = opElement.getAttribute("activated");
            if (activationString.equals("no") || activationString.equals("false")) {
                operator.setEnabled(false);
            } else if (activationString.equals("yes") || activationString.equals("true")) {
                operator.setEnabled(true);
            } else {
                throw new XMLException("Activation mode `" + activationString + "` is not defined!");
            }
        }
        if (opElement.hasAttribute("expanded")) {
            String expansionString = opElement.getAttribute("expanded");
            if ("no".equals(expansionString) || "false".equals(expansionString)) {
                operator.setExpanded(false);
            } else if ("yes".equals(expansionString) || "true".equals(expansionString)) {
                operator.setExpanded(true);
            } else {
                throw new XMLException("Expansion mode `" + expansionString + "` is not defined!");
            }
        }
        if (addToProcess != null) {
            addToProcess.addOperator(operator);
        }
        NodeList innerTags = opElement.getChildNodes();
        for (i = 0; i < innerTags.getLength(); ++i) {
            String key2;
            Node node = innerTags.item(i);
            if (!(node instanceof Element)) continue;
            Element inner = (Element)node;
            if (inner.getTagName().toLowerCase().equals("description")) {
                if (inner.hasAttribute("text")) {
                    String descriptionText = inner.getAttribute("text");
                    if (processFileVersion.compareTo(VERSION_RM_5) < 0) {
                        descriptionText = descriptionText.replaceAll("#yquot#", "&quot;");
                        descriptionText = descriptionText.replaceAll("#ygt#", ">");
                        descriptionText = descriptionText.replaceAll("#ylt#", "<");
                    }
                    operator.setUserDescription(descriptionText);
                    if (processFileVersion.compareTo(VERSION_RM_5) < 0) continue;
                    this.addMessage("The tag &lt;description text=\"TEXT\"&gt; is deprecated. From version 5.0 on, use &lt;description&gt;TEXT&lt;/description&gt;.");
                    continue;
                }
                String textContent = inner.getTextContent();
                if (textContent != null && textContent.length() > 0) {
                    operator.setUserDescription(textContent);
                    if (processFileVersion.compareTo(VERSION_RM_5) >= 0) continue;
                    this.addMessage("The tag &lt;description&gt; is missing a text attribute. Using the version 5.0 style XML text content as description text.");
                    continue;
                }
                if (processFileVersion.compareTo(VERSION_RM_5) >= 0) continue;
                this.addMessage("The tag &lt;description&gt; is missing a text attribute.");
                continue;
            }
            if (inner.getTagName().toLowerCase().equals("parameter")) {
                String[] parameter = this.parseParameter(inner);
                boolean knownType = operator.getParameters().setParameter(parameter[0], parameter[1]);
                if (knownType || !this.relevantParameter(className, parameter[0])) continue;
                this.addMessage("The parameter '<code>" + parameter[0] + "</code>' is unknown for operator '<var>" + operator.getName() + "</var>' (<code>" + operator.getOperatorDescription().getName() + "</code>).");
                unknownParameterInformation.add(new UnknownParameterInformation(operator.getName(), operator.getOperatorDescription().getName(), parameter[0], parameter[1]));
                continue;
            }
            if (inner.getTagName().toLowerCase().equals("list")) {
                key2 = inner.getAttribute("key");
                ParameterType type = operator.getParameters().getParameterType(key2);
                if (type == null) {
                    if (!this.relevantParameter(className, key2)) continue;
                    this.addMessage("The parameter '" + key2 + "' of type list is unknown for operator '" + operator.getName() + "' (" + operator.getOperatorDescription().getName() + ").");
                    unknownParameterInformation.add(new UnknownParameterInformation(operator.getName(), operator.getOperatorDescription().getName(), key2, ""));
                    continue;
                }
                if (!(type instanceof ParameterTypeList)) {
                    this.addMessage("The parameter '" + type.getKey() + "' is a " + type.getClass().getSimpleName() + ", but a list was found.");
                    type = null;
                }
                ListDescription listDescription = this.parseParameterList(inner, (ParameterTypeList)type);
                String listString = ParameterTypeList.transformList2String(listDescription.getList());
                boolean knownType = operator.getParameters().setParameter(listDescription.getKey(), listString);
                if (knownType || !this.relevantParameter(className, listDescription.getKey())) continue;
                this.addMessage("The parameter '" + listDescription.getKey() + "' is unknown for operator '" + operator.getName() + "' (" + operator.getOperatorDescription().getName() + ").");
                unknownParameterInformation.add(new UnknownParameterInformation(operator.getName(), operator.getOperatorDescription().getName(), listDescription.getKey(), listDescription.getList().toString()));
                continue;
            }
            if (inner.getTagName().toLowerCase().equals("enumeration")) {
                key2 = inner.getAttribute("key");
                ParameterType type = operator.getParameters().getParameterType(key2);
                if (type == null) {
                    if (!this.relevantParameter(className, key2)) continue;
                    this.addMessage("The parameter '" + key2 + "' of type enumeration is unknown for operator '" + operator.getName() + "' (" + operator.getOperatorDescription().getName() + ").");
                    unknownParameterInformation.add(new UnknownParameterInformation(operator.getName(), operator.getOperatorDescription().getName(), key2, ""));
                    continue;
                }
                if (!(type instanceof ParameterTypeEnumeration)) {
                    this.addMessage("The parameter '" + type.getKey() + "' is a " + type.getClass().getSimpleName() + ", but an enumeration was found.");
                    type = null;
                }
                List<String> parsed = this.parseParameterEnumeration(inner, (ParameterTypeEnumeration)type);
                boolean knownType = operator.getParameters().setParameter(key2, ParameterTypeEnumeration.transformEnumeration2String(parsed));
                if (knownType || !this.relevantParameter(className, key2)) continue;
                this.addMessage("The parameter '" + key2 + "' is unknown for operator '" + operator.getName() + "' (" + operator.getOperatorDescription().getName() + ").");
                unknownParameterInformation.add(new UnknownParameterInformation(operator.getName(), operator.getOperatorDescription().getName(), key2, parsed.toString()));
                continue;
            }
            if (inner.getTagName().toLowerCase().equals("description")) {
                operator.setUserDescription(inner.getAttribute("text"));
                continue;
            }
            if (inner.getTagName().toLowerCase().equals("operator") || inner.getTagName().toLowerCase().equals("process")) {
                if (operator instanceof OperatorChain) continue;
                this.addMessage("<em class=\"error\">Operator '<class>" + operator.getOperatorDescription().getName() + "</class>' may not have children. Ignoring.");
                continue;
            }
            this.addMessage("<em class=\"error\">Ignoring unknown inner tag for <code>&gt;operator&lt;</code>: <code>&lt;" + inner.getTagName() + "&gt;</code>.");
        }
        if (operator instanceof OperatorChain) {
            OperatorChain nop = (OperatorChain)operator;
            NodeList children = opElement.getChildNodes();
            int subprocessIndex = 0;
            for (int i3 = 0; i3 < children.getLength(); ++i3) {
                ExecutionUnit subprocess;
                Element childProcessElement;
                Node child = children.item(i3);
                if (!(child instanceof Element) || !"process".equals((childProcessElement = (Element)child).getTagName()) && !"operator".equals(childProcessElement.getTagName())) continue;
                if (subprocessIndex >= nop.getNumberOfSubprocesses() && !nop.areSubprocessesExtendable()) {
                    this.addMessage("<em class=\"error\">Cannot add child " + childProcessElement.getAttribute("name") + "</var>.</em> Operator <code>" + nop.getOperatorDescription().getName() + "</code> has only " + nop.getNumberOfSubprocesses() + " subprocesses.");
                    continue;
                }
                if (subprocessIndex >= nop.getNumberOfSubprocesses()) {
                    nop.addSubprocess(subprocessIndex);
                }
                if ("process".equals(childProcessElement.getTagName())) {
                    subprocess = nop.getSubprocess(subprocessIndex);
                    ++subprocessIndex;
                    this.parseProcess(childProcessElement, subprocess, processFileVersion, process, unknownParameterInformation);
                    continue;
                }
                if (!"operator".equals(childProcessElement.getTagName())) continue;
                if (processFileVersion.compareTo(VERSION_RM_5) >= 0) {
                    this.addMessage("<em class=\"error\"><code>&lt;operator&gt;</code> as children of <code>&lt;operator&gt</code> is deprecated syntax. From version 5.0 on, use <code>&lt;process&gt;</code> as children.</em>");
                    continue;
                }
                if (!this.operatorAsDirectChildrenDeprecatedReported) {
                    this.addMessage("<code>&lt;operator&gt;</code> as children of <code>&lt;operator&gt</code> is deprecated syntax. From version 5.0 on, use <code>&lt;process&gt;</code> as children.");
                    this.operatorAsDirectChildrenDeprecatedReported = true;
                }
                subprocess = nop.getSubprocess(subprocessIndex);
                if (subprocessIndex <= nop.getNumberOfSubprocesses() - 2 || nop.areSubprocessesExtendable()) {
                    ++subprocessIndex;
                }
                this.parseOperator(childProcessElement, subprocess, processFileVersion, process, unknownParameterInformation);
                this.mustAutoConnect = true;
            }
        }
        if ((list = OPERATOR_KEY_RULES_MAP.get(key = operator.getOperatorDescription().getKey())) != null) {
            for (ParseRule rule : list) {
                String msg = rule.apply(operator, processFileVersion, this);
                if (msg == null) continue;
                process.setProcessConverted(true);
                this.addMessage(msg);
            }
        }
        return operator;
    }

    private boolean relevantParameter(String opName, String paramName) {
        return !IRRELEVANT_PARAMETERS.contains(opName + "." + paramName) && !IRRELEVANT_PARAMETERS.contains(paramName);
    }

    private List<String> parseList(Element parent, String childName) {
        LinkedList<String> result = new LinkedList<String>();
        NodeList childNodes = parent.getElementsByTagName(childName);
        switch (childNodes.getLength()) {
            case 0: {
                this.addMessage("Missing &lt;" + childName + "&gt; tag in context.");
                break;
            }
            case 1: {
                NodeList locationNodes = ((Element)childNodes.item(0)).getElementsByTagName("location");
                for (int i = 0; i < locationNodes.getLength(); ++i) {
                    result.add(locationNodes.item(i).getTextContent());
                }
                break;
            }
            default: {
                this.addMessage("&lt;context&gt; can have at most one &lt;" + childName + "&gt; tag.");
            }
        }
        return result;
    }

    private void parseContext(Element element, Process process) {
        ProcessContext context = process.getContext();
        context.setInputRepositoryLocations(this.parseList(element, "input"));
        context.setOutputRepositoryLocations(this.parseList(element, "output"));
        NodeList childNodes = element.getElementsByTagName("macros");
        switch (childNodes.getLength()) {
            case 0: {
                this.addMessage("Missing &lt;macros&gt; tag in context.");
                break;
            }
            case 1: {
                NodeList locationNodes = ((Element)childNodes.item(0)).getElementsByTagName("macro");
                for (int i = 0; i < locationNodes.getLength(); ++i) {
                    Element macroElem = (Element)locationNodes.item(i);
                    context.addMacro(new Pair<String, String>(XMLTools.getTagContents(macroElem, "key"), XMLTools.getTagContents(macroElem, "value")));
                }
                break;
            }
            default: {
                this.addMessage("&lt;context&gt; can have at most one &lt;macros&gt; tag.");
            }
        }
    }

    private ListDescription parseParameterList(Element list, ParameterTypeList type) throws XMLException {
        ParameterType keyType = type.getKeyType();
        ParameterType valueType = type.getValueType();
        LinkedList<String[]> values = new LinkedList<String[]>();
        NodeList children = list.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element inner = (Element)node;
            if (inner.getTagName().toLowerCase().equals("parameter")) {
                String key = inner.getAttribute("key");
                String value = inner.getAttribute("value");
                String transformedKey = keyType.transformNewValue(key);
                String transformedValue = valueType.transformNewValue(value);
                values.add(new String[]{transformedKey, transformedValue});
                continue;
            }
            this.addMessage("<em class=\"error\">Ilegal inner tag for <code>&lt;list&gt;</code>: <code>&lt;" + inner.getTagName() + "&gt;</code>.</em>");
            return new ListDescription(list.getAttribute("key"), Collections.<String[]>emptyList());
        }
        return new ListDescription(list.getAttribute("key"), values);
    }

    private List<String> parseParameterEnumeration(Element list, ParameterTypeEnumeration type) throws XMLException {
        LinkedList<String> values = new LinkedList<String>();
        NodeList children = list.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element inner = (Element)node;
            if (inner.getTagName().toLowerCase().equals("parameter")) {
                values.add(type.getValueType().transformNewValue(inner.getAttribute("value")));
                continue;
            }
            this.addMessage("<em class=\"error\">Ilegal inner tag for <code>&lt;enumeration&gt;</code>: <code>&lt;" + inner.getTagName() + "&gt;</code>.</em>");
            return new LinkedList<String>();
        }
        return values;
    }

    private String[] parseParameter(Element parameter) {
        return new String[]{parameter.getAttribute("key"), parameter.getAttribute("value")};
    }

    private VersionNumber parseVersion(Element element) {
        if (element.hasAttribute("version")) {
            try {
                VersionNumber version = new VersionNumber(element.getAttribute("version"));
                return version;
            }
            catch (NumberFormatException e) {
                this.addMessage("<em class=\"error\">The version " + element.getAttribute("version") + " is not a legal RapidMiner version, assuming 4.0.</em>");
                return new VersionNumber(4, 0);
            }
        }
        this.addMessage("<em class=\"error\">Found no version information, assuming 4.0.</em>");
        return new VersionNumber(4, 0);
    }

    private void unlockPorts(Operator operator) {
        operator.getInputPorts().unlockPortExtenders();
        operator.getOutputPorts().unlockPortExtenders();
        if (operator instanceof OperatorChain) {
            for (ExecutionUnit unit : ((OperatorChain)operator).getSubprocesses()) {
                unit.getInnerSinks().unlockPortExtenders();
                unit.getInnerSources().unlockPortExtenders();
                for (Operator child : unit.getOperators()) {
                    this.unlockPorts(child);
                }
            }
        }
    }

    public void doAfterAutoWire(Runnable runnable) {
        this.jobsAfterAutoWire.add(runnable);
    }

    public void doAfterTreeConstruction(Runnable runnable) {
        this.jobsAfterTreeConstruction.add(runnable);
    }

    private boolean hasMessage() {
        return this.messages.length() > 0;
    }

    private String getMessage() {
        return "<html><body><h3>Importing process produced the following messages:</h3><ol>" + this.messages.toString() + "</ol></body></html>";
    }

    static {
        CURRENT_VERSION = VERSION_RM_5 = new VersionNumber(5, 0);
        IRRELEVANT_PARAMETERS = new HashSet<String>();
        IRRELEVANT_PARAMETERS.add("read_database.data_set_meta_data_information");
        PROCESS_FILE_CHARSET = Charset.forName("UTF-8");
        PARSE_RULES = new LinkedList<ParseRule>();
        OPERATOR_KEY_RULES_MAP = new HashMap();
    }
}

