/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process;

import com.rapidminer.BreakpointListener;
import com.rapidminer.Process;
import com.rapidminer.ProcessContext;
import com.rapidminer.RapidMiner;
import com.rapidminer.io.process.ProcessXMLFilterRegistry;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorVersion;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.tools.container.Pair;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLExporter {
    private boolean onlyCoreElements = false;

    public XMLExporter() {
        this(false);
    }

    public XMLExporter(boolean onlyCoreElements) {
        this.onlyCoreElements = onlyCoreElements;
    }

    public Document exportProcess(Operator operator, boolean hideDefault) throws IOException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = doc.createElement("process");
            doc.appendChild(rootElement);
            rootElement.setAttribute("version", RapidMiner.getLongVersion());
            Process process = operator.getProcess();
            if (process != null) {
                rootElement.appendChild(this.exportProcessContext(process.getContext(), doc));
                if (!process.getAnnotations().isEmpty()) {
                    rootElement.appendChild(this.exportAnnotations(process.getAnnotations(), doc));
                }
            }
            rootElement.appendChild(this.exportOperator(operator, hideDefault, doc));
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Cannot create XML document builder: " + e, e);
        }
    }

    public Document exportSingleOperator(Operator operator) throws IOException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            doc.appendChild(this.exportOperator(operator, false, doc));
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Cannot create XML document builder: " + e, e);
        }
    }

    private Element exportOperator(Operator operator, boolean hideDefault, Document doc) {
        Element opElement = doc.createElement("operator");
        opElement.setAttribute("name", operator.getName());
        opElement.setAttribute("class", operator.getOperatorDescription().getKey());
        OperatorVersion opVersion = operator.getCompatibilityLevel();
        if (opVersion == null) {
            opVersion = OperatorVersion.getLatestVersion(operator.getOperatorDescription());
        }
        opElement.setAttribute("compatibility", opVersion.toString());
        StringBuilder breakpointString = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < BreakpointListener.BREAKPOINT_POS_NAME.length; ++i) {
            if (!operator.hasBreakpoint(i)) continue;
            if (first) {
                first = false;
            } else {
                breakpointString.append(",");
            }
            breakpointString.append(BreakpointListener.BREAKPOINT_POS_NAME[i]);
        }
        if (!first) {
            opElement.setAttribute("breakpoints", breakpointString.toString());
        }
        opElement.setAttribute("expanded", operator.isExpanded() ? "true" : "false");
        opElement.setAttribute("activated", operator.isEnabled() ? "true" : "false");
        String description = operator.getUserDescription();
        if (description != null && description.length() > 0) {
            Element descrElem = doc.createElement("description");
            descrElem.appendChild(doc.createTextNode(description));
            opElement.appendChild(descrElem);
        }
        operator.getParameters().appendXML(opElement, hideDefault, doc);
        if (operator instanceof OperatorChain) {
            OperatorChain nop = (OperatorChain)operator;
            for (ExecutionUnit executionUnit : nop.getSubprocesses()) {
                opElement.appendChild(this.exportExecutionUnit(executionUnit, hideDefault, doc, false));
            }
        }
        if (!this.onlyCoreElements) {
            ProcessXMLFilterRegistry.fireOperatorExported(operator, opElement);
        }
        return opElement;
    }

    private Element exportExecutionUnit(ExecutionUnit executionUnit, boolean hideDefault, Document doc, boolean isRoot) {
        Element procElement = isRoot ? doc.createElementNS("http://www.rapidminer.com/xml/schema/RapidMinerProcess", "process") : doc.createElement("process");
        procElement.setAttribute("expanded", executionUnit.isExpanded() ? "true" : "false");
        for (Operator op : executionUnit.getOperators()) {
            procElement.appendChild(this.exportOperator(op, hideDefault, doc));
        }
        this.exportConnections(executionUnit.getInnerSources(), executionUnit, procElement, doc);
        for (Operator op : executionUnit.getOperators()) {
            this.exportConnections(op.getOutputPorts(), executionUnit, procElement, doc);
        }
        if (!this.onlyCoreElements) {
            ProcessXMLFilterRegistry.fireExecutionUnitExported(executionUnit, procElement);
        }
        return procElement;
    }

    private void exportConnections(OutputPorts outputPorts, ExecutionUnit processInScope, Element insertInto, Document doc) {
        for (OutputPort outputPort : outputPorts.getAllPorts()) {
            if (!outputPort.isConnected()) continue;
            Element portElement = doc.createElement("connect");
            if (processInScope.getEnclosingOperator() != outputPorts.getOwner().getOperator()) {
                portElement.setAttribute("from_op", outputPorts.getOwner().getOperator().getName());
            }
            portElement.setAttribute("from_port", outputPort.getName());
            InputPort destination = outputPort.getDestination();
            if (processInScope.getEnclosingOperator() != destination.getPorts().getOwner().getOperator()) {
                portElement.setAttribute("to_op", destination.getPorts().getOwner().getOperator().getName());
            }
            portElement.setAttribute("to_port", destination.getName());
            insertInto.appendChild(portElement);
        }
    }

    private static void appendList(Element element, String name, List<String> locations) {
        String loc;
        Document doc = element.getOwnerDocument();
        Element list = doc.createElement(name);
        element.appendChild(list);
        LinkedList<String> nonNull = new LinkedList<String>(locations);
        Collections.reverse(nonNull);
        Iterator i = nonNull.iterator();
        while (i.hasNext() && ((loc = (String)i.next()) == null || loc.isEmpty())) {
            i.remove();
        }
        Collections.reverse(nonNull);
        for (String loc2 : nonNull) {
            Element stringElem = doc.createElement("location");
            list.appendChild(stringElem);
            stringElem.appendChild(doc.createTextNode(loc2));
        }
    }

    private Element exportProcessContext(ProcessContext context, Document doc) {
        Element element = doc.createElement("context");
        XMLExporter.appendList(element, "input", context.getInputRepositoryLocations());
        XMLExporter.appendList(element, "output", context.getOutputRepositoryLocations());
        Element macrosElem = doc.createElement("macros");
        element.appendChild(macrosElem);
        for (Pair<String, String> macro : context.getMacros()) {
            Element macroElement = doc.createElement("macro");
            macrosElem.appendChild(macroElement);
            Element key = doc.createElement("key");
            macroElement.appendChild(key);
            key.appendChild(doc.createTextNode(macro.getFirst()));
            Element value = doc.createElement("value");
            macroElement.appendChild(value);
            value.appendChild(doc.createTextNode(macro.getSecond()));
        }
        return element;
    }

    private Element exportAnnotations(Annotations annotations, Document doc) {
        return annotations.toXML(doc);
    }
}

