/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.io.process;

import java.util.LinkedList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLErrorHandler
implements ErrorHandler {
    private final String sourceName;
    private final List<SAXParseException> warnings = new LinkedList<SAXParseException>();
    private final List<SAXParseException> errors = new LinkedList<SAXParseException>();

    public XMLErrorHandler(String sourceName) {
        this.sourceName = sourceName;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.errors.add(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.errors.add(exception);
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.warnings.add(exception);
    }

    private String toString(SAXParseException e) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.sourceName);
        buf.append(" (");
        buf.append(e.getLineNumber());
        buf.append(":");
        buf.append(e.getColumnNumber());
        buf.append(" at ");
        buf.append(e.getPublicId());
        buf.append(") ");
        buf.append(e.getLocalizedMessage());
        return buf.toString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!this.errors.isEmpty()) {
            b.append("Errors:\n");
            for (SAXParseException e : this.errors) {
                b.append(this.toString(e));
                b.append("\n");
            }
        }
        if (!this.warnings.isEmpty()) {
            b.append("\nWarnings:\n");
            for (SAXParseException e : this.warnings) {
                b.append(this.toString(e));
                b.append("\n");
            }
        }
        return b.toString();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }
}

