/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.wizards;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.gui.EditorCellRenderer;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.att.AttributeDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ExampleSourceConfigurationWizardValueTypeTable
extends ExtendedJTable {
    private static final long serialVersionUID = -6402806364622312588L;
    private ExampleSourceConfigurationWizardValueTypeTableModel model;

    public ExampleSourceConfigurationWizardValueTypeTable(List<AttributeDataSource> sources) {
        super(false);
        this.setAutoResizeMode(0);
        this.model = new ExampleSourceConfigurationWizardValueTypeTableModel(sources);
        this.setModel(this.model);
        this.update();
    }

    public void guessValueTypes(File data, String commentString, String columnSeparators, char decimalPointCharacter, boolean useQuotes, boolean firstLineAsNames) {
        this.model.guessValueTypes(data, commentString, columnSeparators, decimalPointCharacter, useQuotes, firstLineAsNames);
    }

    public void update() {
        ((AbstractTableModel)this.getModel()).fireTableStructureChanged();
        TableColumnModel columnModel = this.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = columnModel.getColumn(i);
            tableColumn.setPreferredWidth(120);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        LinkedList<String> usedTypes = new LinkedList<String>();
        for (int i = 0; i < Ontology.VALUE_TYPE_NAMES.length; ++i) {
            if (i == 0 || i == 8 || Ontology.ATTRIBUTE_VALUE_TYPE.isA(i, 9)) continue;
            usedTypes.add(Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(i));
        }
        String[] valueTypes = new String[usedTypes.size()];
        int vCounter = 0;
        for (String type : usedTypes) {
            valueTypes[vCounter++] = type;
        }
        JComboBox<String> typeBox = new JComboBox<String>(valueTypes);
        typeBox.setBackground(UIManager.getColor("Table.cellBackground"));
        return new DefaultCellEditor(typeBox);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return new EditorCellRenderer(this.getCellEditor(row, column));
    }

    private static class ExampleSourceConfigurationWizardValueTypeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8459288119418286682L;
        private List<AttributeDataSource> sources;

        public ExampleSourceConfigurationWizardValueTypeTableModel(List<AttributeDataSource> sources) {
            this.sources = sources;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void guessValueTypes(File originalDataFile, String commentString, String columnSeparators, char decimalPointCharacter, boolean useQuotes, boolean firstLineAsNames) {
            Pattern separatorPattern = Pattern.compile(columnSeparators);
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(originalDataFile));
                String line = null;
                boolean first = true;
                boolean[] hasToCheck = null;
                boolean[] onlyMissing = null;
                int rowCounter = 1;
                while ((line = in.readLine()) != null) {
                    if (commentString != null && commentString.trim().length() > 0 && line.startsWith(commentString) || line.trim().length() == 0) continue;
                    String[] row = null;
                    row = useQuotes ? Tools.quotedSplit(line, separatorPattern) : line.trim().split(columnSeparators);
                    if (first) {
                        hasToCheck = new boolean[row.length];
                        onlyMissing = new boolean[row.length];
                        for (int i = 0; i < hasToCheck.length; ++i) {
                            hasToCheck[i] = true;
                            onlyMissing[i] = true;
                        }
                        if (!firstLineAsNames) {
                            this.updateValueTypes(row, hasToCheck, onlyMissing, decimalPointCharacter);
                        }
                        first = false;
                    } else {
                        if (row.length != hasToCheck.length) {
                            throw new IOException("Line " + rowCounter + " has a number of columns (" + row.length + ") different from preceding lines (" + hasToCheck.length + ").");
                        }
                        this.updateValueTypes(row, hasToCheck, onlyMissing, decimalPointCharacter);
                    }
                    ++rowCounter;
                }
                for (int m = 0; m < onlyMissing.length; ++m) {
                    if (onlyMissing[m] == false) continue;
                    this.setValueAt(Ontology.VALUE_TYPE_NAMES[1], 0, m);
                }
            }
            catch (IOException e) {
                SwingTools.showSimpleErrorMessage("cannot_guess_value_types", (Throwable)e, new Object[0]);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        SwingTools.showSimpleErrorMessage("cannot_close_stream_to_data_file", (Throwable)e, new Object[0]);
                    }
                }
            }
        }

        private void updateValueTypes(String[] row, boolean[] hasToCheck, boolean[] onlyMissing, char decimalPointCharacter) {
            for (int c = 0; c < row.length; ++c) {
                if (!hasToCheck[c]) continue;
                int valueType = 3;
                String value = row[c];
                if (value != null && value.length() > 0 && !value.equals("?")) {
                    onlyMissing[c] = false;
                    try {
                        String decimalValue = value.replace(decimalPointCharacter, '.');
                        double d = Double.parseDouble(decimalValue);
                        if (valueType == 3 && !Tools.isEqual(Math.round(d), d)) {
                            valueType = 4;
                            hasToCheck[c] = false;
                        }
                    }
                    catch (NumberFormatException e) {
                        valueType = 1;
                        hasToCheck[c] = false;
                    }
                }
                this.setValueAt(Ontology.VALUE_TYPE_NAMES[valueType], 0, c);
            }
        }

        @Override
        public int getColumnCount() {
            return this.sources.size();
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            String valueTypeName = (String)value;
            int valueType = 1;
            for (int i = 0; i < Ontology.VALUE_TYPE_NAMES.length; ++i) {
                if (!Ontology.VALUE_TYPE_NAMES[i].equals(valueTypeName)) continue;
                valueType = i;
                break;
            }
            AttributeDataSource source = this.sources.get(columnIndex);
            Attribute oldAttribute = source.getAttribute();
            source.setAttribute(AttributeFactory.changeValueType(oldAttribute, valueType));
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return Ontology.VALUE_TYPE_NAMES[this.sources.get(columnIndex).getAttribute().getValueType()];
        }

        @Override
        public String getColumnName(int column) {
            return this.sources.get(column).getAttribute().getName();
        }
    }
}

