/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.wizards;

import com.rapidminer.example.Attributes;
import com.rapidminer.gui.EditorCellRenderer;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.tools.att.AttributeDataSource;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ExampleSourceConfigurationWizardAttributeTypeTable
extends ExtendedJTable {
    private static final long serialVersionUID = -2517765684242352099L;

    public ExampleSourceConfigurationWizardAttributeTypeTable(List<AttributeDataSource> sources) {
        super(false);
        this.setAutoResizeMode(0);
        this.setModel(new ExampleSourceConfigurationWizardAttributeTypeTableModel(sources));
        this.setRowHeight(this.getRowHeight() + 10);
        this.update();
    }

    public void update() {
        ((AbstractTableModel)this.getModel()).fireTableStructureChanged();
        TableColumnModel columnModel = this.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = columnModel.getColumn(i);
            tableColumn.setPreferredWidth(120);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        JComboBox<String> typeBox = new JComboBox<String>(Attributes.KNOWN_ATTRIBUTE_TYPES);
        typeBox.setEditable(true);
        typeBox.setBackground(UIManager.getColor("Table.cellBackground"));
        return new DefaultCellEditor(typeBox);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return new EditorCellRenderer(this.getCellEditor(row, column));
    }

    private static class ExampleSourceConfigurationWizardAttributeTypeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -6609321134250471524L;
        private List<AttributeDataSource> sources;

        public ExampleSourceConfigurationWizardAttributeTypeTableModel(List<AttributeDataSource> sources) {
            this.sources = sources;
        }

        @Override
        public int getColumnCount() {
            return this.sources.size();
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            String type = (String)value;
            this.sources.get(columnIndex).setType(type);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.sources.get(columnIndex).getType();
        }

        @Override
        public String getColumnName(int column) {
            return this.sources.get(column).getAttribute().getName();
        }
    }
}

