/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.wizards;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.wizards.AbstractConfigurationWizard;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.gui.wizards.ExampleSourceConfigurationWizardAttributeTypeTable;
import com.rapidminer.gui.wizards.ExampleSourceConfigurationWizardDataTable;
import com.rapidminer.gui.wizards.ExampleSourceConfigurationWizardValueTypeTable;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.att.AttributeDataSource;
import com.rapidminer.tools.io.Encoding;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExampleSourceConfigurationWizard
extends AbstractConfigurationWizard {
    private static final long serialVersionUID = 1261772342282270078L;
    private static final int MAX_NUMBER_OF_LINES = 200;
    private static final int TITLE_STEP = 0;
    private static final int DATA_LOADING_STEP = 1;
    private static final int COLUMN_STEP = 2;
    private static final int NAME_STEP = 3;
    private static final int VALUE_TYPE_STEP = 4;
    private static final int ATTRIBUTE_TYPE_STEP = 5;
    private static final int RESULT_FILE_STEP = 6;
    private ArrayList<AttributeDataSource> sources = new ArrayList();
    private List<String[]> data = new ArrayList<String[]>();
    private JTextField fileTextField = new JTextField(40);
    private JTextField commentCharField = new JTextField("#");
    private JTextField decimalPointCharacterField = new JTextField(".");
    private JCheckBox quoteCheckBox = new JCheckBox((String)null, true);
    private JRadioButton semicolonButton = new JRadioButton("Separated by ;");
    private JRadioButton commaButton = new JRadioButton("Separated by ,");
    private JRadioButton tabButton = new JRadioButton("Separated by tabulars [\\t]");
    private JRadioButton whiteSpaceButton = new JRadioButton("Separated by any white space [\\s+]");
    private JRadioButton regExpButton = new JRadioButton("Separation defined by a regular expression (default)");
    private JTextField columnSeparatorTextField = new JTextField(",\\s*|;\\s*|\\s+");
    private JCheckBox firstRowAsNames = new JCheckBox("Use first row for column names", false);
    private ExampleSourceConfigurationWizardDataTable dataView = new ExampleSourceConfigurationWizardDataTable(this.sources, this.data);
    private JScrollPane dataViewPane = new ExtendedJScrollPane(this.dataView);
    private ExampleSourceConfigurationWizardValueTypeTable valueTypeView = new ExampleSourceConfigurationWizardValueTypeTable(this.sources);
    private ExampleSourceConfigurationWizardAttributeTypeTable attributeTypeView = new ExampleSourceConfigurationWizardAttributeTypeTable(this.sources);
    private JTextField resultFileField = new JTextField(40);

    public ExampleSourceConfigurationWizard(ConfigurationListener listener) {
        super("Example Source Wizard", listener);
        this.dataViewPane.setVisible(false);
        this.addTitleStep();
        this.addDataLoadingStep();
        this.addColumnSeparatorStep();
        this.addNameDefinitionStep();
        this.addValueTypeDefinitionStep();
        this.addAttributeTypeDefinitionStep();
        this.addResultFileDefinitionStep();
        this.addBottomComponent(this.dataViewPane);
    }

    private void addTitleStep() {
        JPanel panel = SwingTools.createTextPanel("Welcome to the Example Source Wizard", "This wizard will guide you through the process of data loading and meta data definition. Using this wizard will involve the following steps:<ul><li>Selection of a data file</li><li>Definition of the column separators</li><li>Definition of the attribute names</li><li>Definition of the attribute value types</li><li>Definition of special attributes like labels or IDs</li><li>Saving the data and meta data into files used by the operator</li></ul>");
        this.addStep(panel);
    }

    private void addDataLoadingStep() {
        JPanel panel = SwingTools.createTextPanel("Please specify a data file...", "Please specify the location of a data file. The format can almost be arbitrary as long as it is in any way a attribute value format with columns for attribute values and rows for examples.");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        JLabel label = new JLabel("File: ");
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = -1;
        layout.setConstraints(this.fileTextField, c);
        content.add(this.fileTextField);
        JButton chooseFileButton = new JButton("Choose...");
        chooseFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = SwingTools.chooseFile(ExampleSourceConfigurationWizard.this, null, true, null, null);
                if (file != null) {
                    ExampleSourceConfigurationWizard.this.fileTextField.setText(file.getAbsolutePath());
                }
            }
        });
        c.weightx = 0.0;
        c.gridwidth = 0;
        layout.setConstraints(chooseFileButton, c);
        content.add(chooseFileButton);
        c.gridwidth = -1;
        label = new JLabel("Comment characters (optional): ");
        c.weightx = 0.0;
        c.gridwidth = 1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        layout.setConstraints(this.commentCharField, c);
        content.add(this.commentCharField);
        JPanel fillPanel = new JPanel();
        c.weightx = 0.0;
        c.gridwidth = 0;
        layout.setConstraints(fillPanel, c);
        content.add(fillPanel);
        c.gridwidth = -1;
        label = new JLabel("Decimal point character: ");
        c.weightx = 0.0;
        c.gridwidth = 1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        layout.setConstraints(this.decimalPointCharacterField, c);
        content.add(this.decimalPointCharacterField);
        fillPanel = new JPanel();
        c.weightx = 0.0;
        c.gridwidth = 0;
        layout.setConstraints(fillPanel, c);
        content.add(fillPanel);
        c.gridwidth = -1;
        label = new JLabel("Use double quotes (\"): ");
        c.weightx = 0.0;
        c.gridwidth = 1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        layout.setConstraints(this.quoteCheckBox, c);
        content.add(this.quoteCheckBox);
        fillPanel = new JPanel();
        c.weightx = 0.0;
        c.gridwidth = 0;
        layout.setConstraints(fillPanel, c);
        content.add(fillPanel);
        JPanel yFillPanel = new JPanel();
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(yFillPanel, c);
        content.add(yFillPanel);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addColumnSeparatorStep() {
        JPanel panel = SwingTools.createTextPanel("Please specify a column separator...", "Please specify a column separator. The default separator will separate columns after , or ; followed by an arbitrary number of white spaces or by white space alone. Please note that only the first few lines of the data file will be shown.");
        this.regExpButton.setSelected(true);
        Box buttonBox = new Box(1);
        this.semicolonButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleSourceConfigurationWizard.this.reloadData();
                ExampleSourceConfigurationWizard.this.updateViews();
            }
        });
        buttonBox.add(this.semicolonButton);
        this.commaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleSourceConfigurationWizard.this.reloadData();
                ExampleSourceConfigurationWizard.this.updateViews();
            }
        });
        buttonBox.add(this.commaButton);
        this.tabButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleSourceConfigurationWizard.this.reloadData();
                ExampleSourceConfigurationWizard.this.updateViews();
            }
        });
        buttonBox.add(this.tabButton);
        this.whiteSpaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleSourceConfigurationWizard.this.reloadData();
                ExampleSourceConfigurationWizard.this.updateViews();
            }
        });
        buttonBox.add(this.whiteSpaceButton);
        this.regExpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleSourceConfigurationWizard.this.reloadData();
                ExampleSourceConfigurationWizard.this.updateViews();
            }
        });
        buttonBox.add(this.regExpButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.semicolonButton);
        group.add(this.commaButton);
        group.add(this.tabButton);
        group.add(this.whiteSpaceButton);
        group.add(this.regExpButton);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 11;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.gridheight = 2;
        layout.setConstraints(buttonBox, c);
        content.add(buttonBox);
        JLabel label = new JLabel("Regular expression: ");
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.gridheight = 1;
        layout.setConstraints(label, c);
        content.add(label);
        GridBagLayout regExpLayout = new GridBagLayout();
        GridBagConstraints regExpC = new GridBagConstraints();
        JPanel regExpPanel = new JPanel(regExpLayout);
        regExpC.fill = 2;
        regExpC.insets = new Insets(7, 7, 7, 7);
        regExpC.gridwidth = -1;
        regExpC.weightx = 1.0;
        regExpLayout.setConstraints(this.columnSeparatorTextField, regExpC);
        regExpPanel.add(this.columnSeparatorTextField);
        JButton updateButton = new JButton("Update");
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleSourceConfigurationWizard.this.reloadData();
                ExampleSourceConfigurationWizard.this.updateViews();
            }
        });
        regExpC.gridwidth = 0;
        regExpC.weightx = 0.0;
        regExpLayout.setConstraints(updateButton, regExpC);
        regExpPanel.add(updateButton);
        c.gridwidth = 0;
        c.weightx = 1.0;
        layout.setConstraints(regExpPanel, c);
        content.add(regExpPanel);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addNameDefinitionStep() {
        JPanel panel = SwingTools.createTextPanel("Please specify the column names...", "Please specify if the names can be taken from the first line of the data file.");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        this.firstRowAsNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleSourceConfigurationWizard.this.reloadData();
                ExampleSourceConfigurationWizard.this.updateViews();
            }
        });
        c.gridwidth = 0;
        layout.setConstraints(this.firstRowAsNames, c);
        content.add(this.firstRowAsNames);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addValueTypeDefinitionStep() {
        JPanel content = new JPanel(new BorderLayout());
        JPanel textPanel = SwingTools.createTextPanel("Please specify the attribute value types...", "Please specify the attribute value types. RapidMiner tries to guess the value types based on the the complete data file (which might take some time) but some adjustments might still be necessary.");
        content.add((Component)textPanel, "North");
        ExtendedJScrollPane valueTypeViewPane = new ExtendedJScrollPane(this.valueTypeView);
        valueTypeViewPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), BorderFactory.createTitledBorder("Attribute Value Types")));
        content.add((Component)valueTypeViewPane, "Center");
        this.addStep(content);
    }

    private void addAttributeTypeDefinitionStep() {
        JPanel content = new JPanel(new BorderLayout());
        JPanel textPanel = SwingTools.createTextPanel("Please specify special attributes...", "Please specify special attribues if there are any. You can specify arbitrary special attributes in the Attribute Editor but in this Wizard only the most important types (label, id...) are supported.");
        content.add((Component)textPanel, "North");
        ExtendedJScrollPane typeViewPane = new ExtendedJScrollPane(this.attributeTypeView);
        typeViewPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), BorderFactory.createTitledBorder("Attribute Types")));
        content.add((Component)typeViewPane, "Center");
        this.addStep(content);
    }

    private void addResultFileDefinitionStep() {
        JPanel panel = SwingTools.createTextPanel("Please specify a file name...", "Please specify a file name which is used for the created attribute description file (.aml) based on the settings before. A corresponding data file will automatically be saved with the extension \".dat\". Please note that existing files with these names will be overwritten. It is not possible to use the input file directly as output.Both files are necessary parameters for the ExampleSource operator and will - like all other important parameters - automatically be defined for this operator after this wizard was finished.");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        JLabel label = new JLabel("Result file name: ");
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = -1;
        layout.setConstraints(this.resultFileField, c);
        content.add(this.resultFileField);
        JButton chooseFileButton = new JButton("Choose...");
        chooseFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = SwingTools.chooseFile(ExampleSourceConfigurationWizard.this, null, false, "aml", "attribute description file");
                boolean fileOk = ExampleSourceConfigurationWizard.this.checkOutputFile(file);
                if (fileOk) {
                    ExampleSourceConfigurationWizard.this.resultFileField.setText(file.getAbsolutePath());
                } else {
                    SwingTools.showVerySimpleErrorMessage("same_output_as_input_file", new Object[0]);
                    ExampleSourceConfigurationWizard.this.resultFileField.setText("");
                }
            }
        });
        c.weightx = 0.0;
        c.gridwidth = 0;
        layout.setConstraints(chooseFileButton, c);
        content.add(chooseFileButton);
        JPanel yFillPanel = new JPanel();
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(yFillPanel, c);
        content.add(yFillPanel);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private boolean checkOutputFile(File file) {
        String path;
        File originalDataFile = new File(this.fileTextField.getText());
        String originalPath = originalDataFile.getAbsolutePath();
        if (originalPath.equals(path = file.getAbsolutePath())) {
            return false;
        }
        if (path.endsWith(".aml")) {
            path = path.substring(0, path.lastIndexOf(".aml"));
        }
        if (originalPath.equals(path + ".dat")) {
            return false;
        }
        return !originalPath.equals(path + ".aml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadData() {
        String defaultName;
        this.sources.clear();
        this.data.clear();
        if (this.fileTextField.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please specify a data file!", "No data file specified", 2);
            return;
        }
        File file = new File(this.fileTextField.getText());
        String commentString = this.commentCharField.getText();
        String columnSeparators = this.getColumnSeparators();
        boolean useQuotes = this.quoteCheckBox.isSelected();
        boolean firstLineAsNames = this.firstRowAsNames.isSelected();
        Pattern separatorPattern = Pattern.compile(columnSeparators);
        String[] columnNames = null;
        int maxColumns = 0;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            String line = null;
            int counter = 0;
            boolean first = true;
            while ((line = in.readLine()) != null && counter <= 200) {
                if (commentString != null && commentString.trim().length() > 0 && line.startsWith(commentString)) continue;
                String[] columns = null;
                columns = useQuotes ? Tools.quotedSplit(line, separatorPattern) : line.trim().split(columnSeparators);
                maxColumns = Math.max(maxColumns, columns.length);
                if (first) {
                    if (firstLineAsNames) {
                        columnNames = columns;
                    } else {
                        this.data.add(columns);
                    }
                    first = false;
                } else {
                    this.data.add(columns);
                }
                ++counter;
            }
        }
        catch (IOException e) {
            SwingTools.showSimpleErrorMessage("cannot_load_data", (Throwable)e, new Object[0]);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    SwingTools.showSimpleErrorMessage("cannot_close_stream_to_data_file", (Throwable)e, new Object[0]);
                }
            }
        }
        if (columnNames == null) {
            defaultName = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1);
            columnNames = new String[maxColumns];
            for (int i = 0; i < columnNames.length; ++i) {
                columnNames[i] = defaultName + " (" + (i + 1) + ")";
            }
        } else if (columnNames.length < maxColumns) {
            defaultName = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1);
            String[] newColumnNames = new String[maxColumns];
            System.arraycopy(columnNames, 0, newColumnNames, 0, columnNames.length);
            for (int i = columnNames.length; i < newColumnNames.length; ++i) {
                newColumnNames[i] = defaultName + " (" + (i + 1) + ")";
            }
        }
        for (int i = 0; i < maxColumns; ++i) {
            this.sources.add(new AttributeDataSource(AttributeFactory.createAttribute(columnNames[i], 1), file, i, "attribute"));
        }
    }

    private String getColumnSeparators() {
        String columnSeparators = this.columnSeparatorTextField.getText();
        if (this.semicolonButton.isSelected()) {
            columnSeparators = ";";
        } else if (this.commaButton.isSelected()) {
            columnSeparators = ",";
        } else if (this.tabButton.isSelected()) {
            columnSeparators = "\\t";
        } else if (this.whiteSpaceButton.isSelected()) {
            columnSeparators = "\\s+";
        }
        return columnSeparators;
    }

    private char getDecimalPointCharacter() {
        String decimalPointString = this.decimalPointCharacterField.getText();
        char decimalPointCharacter = '.';
        if (decimalPointString != null && decimalPointString.length() > 0) {
            decimalPointCharacter = decimalPointString.charAt(0);
        }
        return decimalPointCharacter;
    }

    private void updateViews() {
        this.dataView.update();
        this.dataViewPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), BorderFactory.createTitledBorder("Data Example (" + this.data.size() + " rows, " + this.sources.size() + " columns)")));
        this.valueTypeView.update();
        this.attributeTypeView.update();
    }

    @Override
    public boolean validateCurrentStep(int currentStep, int newStep) {
        if (currentStep > 0 && newStep > currentStep && this.fileTextField.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please specify a data file!", "No data file specified", 2);
            return false;
        }
        return true;
    }

    @Override
    protected void performStepAction(int currentStep, int oldStep) {
        if (currentStep > 1 && currentStep < this.getNumberOfSteps() - 1) {
            this.dataViewPane.setVisible(true);
        } else {
            this.dataViewPane.setVisible(false);
        }
        switch (currentStep) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.reloadData();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                String commentString = this.commentCharField.getText();
                String columnSeparators = this.getColumnSeparators();
                char decimalPointCharacter = this.getDecimalPointCharacter();
                boolean useQuotes = this.quoteCheckBox.isSelected();
                boolean firstLineAsNames = this.firstRowAsNames.isSelected();
                this.valueTypeView.guessValueTypes(new File(this.fileTextField.getText()), commentString, columnSeparators, decimalPointCharacter, useQuotes, firstLineAsNames);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                for (int i = 1; i < Attributes.KNOWN_ATTRIBUTE_TYPES.length; ++i) {
                    this.ensureAttributeTypeIsUnique(Attributes.KNOWN_ATTRIBUTE_TYPES[i]);
                }
                break;
            }
        }
        this.updateViews();
    }

    @Override
    protected void finish(ConfigurationListener listener) {
        String resultFileName = this.resultFileField.getText().trim();
        File resultFile = new File(resultFileName);
        boolean outputFileOk = this.checkOutputFile(resultFile);
        if (!outputFileOk) {
            SwingTools.showVerySimpleErrorMessage("same_output_as_input_file", new Object[0]);
        } else if (this.sources.size() == 0 || this.data.size() == 0) {
            SwingTools.showVerySimpleErrorMessage("no_data_file_and_proper_settings", new Object[0]);
        } else if (resultFileName.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("no_file_name_for_attr_desc", new Object[0]);
        } else {
            Charset encoding = Tools.getDefaultEncoding();
            try {
                encoding = Encoding.getEncoding(listener.getProcess().getRootOperator());
            }
            catch (Exception e) {
                // empty catch block
            }
            File attributeFile = new File(resultFileName);
            File dataFile = new File(resultFileName.substring(0, resultFileName.lastIndexOf(".") + 1) + "dat");
            try {
                this.writeData(dataFile, encoding);
                this.writeAttributeDescriptions(attributeFile, encoding);
            }
            catch (IOException e) {
                SwingTools.showSimpleErrorMessage("es_conf_wizard_was_not_able_to_write_file", (Throwable)e, new Object[0]);
            }
            Parameters parameters = listener.getParameters();
            parameters.setParameter("attributes", attributeFile.getAbsolutePath());
            parameters.setParameter("comment_chars", this.commentCharField.getText());
            listener.setParameters(parameters);
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(File file, Charset encoding) throws IOException {
        for (int i = 0; i < this.sources.size(); ++i) {
            AttributeDataSource source = this.sources.get(i);
            source.setSource(file, i);
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
            File originalDataFile = new File(this.fileTextField.getText());
            String commentString = this.commentCharField.getText();
            String columnSeparators = this.getColumnSeparators();
            char decimalPointCharacter = this.getDecimalPointCharacter();
            boolean useQuotes = this.quoteCheckBox.isSelected();
            boolean firstLineAsNames = this.firstRowAsNames.isSelected();
            Pattern separatorPattern = Pattern.compile(columnSeparators);
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(originalDataFile));
                String line = null;
                boolean first = true;
                while ((line = in.readLine()) != null) {
                    if (commentString != null && commentString.trim().length() > 0 && line.startsWith(commentString)) continue;
                    String[] columns = null;
                    columns = useQuotes ? Tools.quotedSplit(line, separatorPattern) : line.trim().split(columnSeparators);
                    if (first) {
                        if (!firstLineAsNames) {
                            this.writeColumnData(out, columns, decimalPointCharacter);
                        }
                        first = false;
                        continue;
                    }
                    this.writeColumnData(out, columns, decimalPointCharacter);
                }
            }
            catch (IOException e) {
                SwingTools.showSimpleErrorMessage("cannot_re_write_data", (Throwable)e, new Object[0]);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            SwingTools.showSimpleErrorMessage("cannot_re_write_data", (Throwable)e, new Object[0]);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void writeColumnData(PrintWriter out, String[] columnData, char decimalPointCharacter) {
        for (int col = 0; col < columnData.length; ++col) {
            if (col != 0) {
                out.print(", ");
            }
            String value = columnData[col];
            Attribute attribute = this.sources.get(col).getAttribute();
            if (attribute.isNominal()) {
                if ((value = value.replaceAll("\"", "\\\\\"")) != null && value.length() != 0 && !value.equals("?")) {
                    attribute.getMapping().mapString(value);
                }
                if (value != null && !value.equals("?")) {
                    out.print("\"" + value + "\"");
                    continue;
                }
                out.print("?");
                continue;
            }
            String valueString = value.replace(decimalPointCharacter, '.');
            out.print(valueString);
        }
        out.println();
    }

    private void writeAttributeDescriptions(File file, Charset encoding) {
        if (file != null) {
            try {
                this.writeXML(file, encoding);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.toString(), "Error saving attribute file " + file, 0);
            }
        }
    }

    private void writeXML(File attFile, Charset encoding) throws IOException {
        File defaultSource = this.sources.get(0).getFile();
        String relativePath = Tools.getRelativePath(defaultSource, attFile);
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement("attributeset");
            root.setAttribute("default_source", relativePath);
            root.setAttribute("encoding", encoding.name());
            document.appendChild(root);
            int attributeIndex = 0;
            for (AttributeDataSource ads : this.sources) {
                Attribute attribute = ads.getAttribute();
                if (attribute.isNominal()) {
                    for (String[] dataRow : this.data) {
                        if (dataRow[attributeIndex].length() <= 0 || dataRow[attributeIndex].equals("?")) continue;
                        attribute.getMapping().mapString(dataRow[attributeIndex]);
                    }
                }
                ++attributeIndex;
                root.appendChild(ads.writeXML(document, defaultSource));
            }
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(attFile), encoding));
            writer.print(XMLTools.toString(document, encoding));
            writer.close();
        }
        catch (XMLException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    private void ensureAttributeTypeIsUnique(String type) {
        LinkedList<AttributeDataSource> columns = new LinkedList<AttributeDataSource>();
        LinkedList<Integer> columnNumbers = new LinkedList<Integer>();
        Iterator<AttributeDataSource> i = this.sources.iterator();
        int j = 0;
        while (i.hasNext()) {
            AttributeDataSource source = i.next();
            if (source.getType() != null && source.getType().equals(type)) {
                columns.add(source);
                columnNumbers.add(j);
            }
            ++j;
        }
        if (columns.size() > 1) {
            Object[] names = new String[columns.size()];
            int counter = 0;
            for (AttributeDataSource ads : columns) {
                names[counter++] = ads.getAttribute().getName();
            }
            JTextArea message = new JTextArea("The special attribute " + type + " is multiply defined. Please select one of the data columns (others will be changed to regular attributes). Press \"Cancel\" to ignore.", 4, 40);
            message.setEditable(false);
            message.setLineWrap(true);
            message.setWrapStyleWord(true);
            message.setBackground(new JLabel("").getBackground());
            String selection = (String)JOptionPane.showInputDialog(this, message, type + " multiply defined", 2, null, names, names[0]);
            if (selection != null) {
                for (AttributeDataSource source : columns) {
                    if (source.getAttribute().getName().equals(selection)) continue;
                    source.setType("attribute");
                    this.updateViews();
                }
            }
        }
    }
}

