/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.wizards;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceActionAdapter;
import com.rapidminer.gui.wizards.ConfigurationListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public abstract class AbstractConfigurationWizard
extends JDialog {
    private static final Action DUMMY_NEXT_ACTION = new ResourceActionAdapter("next", new Object[0]);
    private static final Action DUMMY_FINISH_ACTION = new ResourceActionAdapter("finish", new Object[0]);
    private static final long serialVersionUID = -2633062859175838003L;
    private JButton previous = new JButton(new ResourceAction("previous", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractConfigurationWizard.this.step(-1);
            AbstractConfigurationWizard.this.next.updateContent();
        }
    });
    private NextButton next = new NextButton();
    private CardLayout cardLayout = new CardLayout();
    private JPanel mainPanel = new JPanel(this.cardLayout);
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private JPanel contentPanel = new JPanel(this.layout);
    private int currentStep = 0;
    private int numberOfSteps = 0;
    private ConfigurationListener listener;

    public AbstractConfigurationWizard(String name, ConfigurationListener listener) {
        super(RapidMinerGUI.getMainFrame(), name, true);
        this.listener = listener;
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.previous);
        buttonPanel.add(this.next);
        buttonPanel.add(Box.createHorizontalStrut(11));
        JButton cancel = new JButton(new ResourceAction("cancel", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractConfigurationWizard.this.cancel();
            }
        });
        buttonPanel.add(cancel);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.c.fill = 1;
        this.c.anchor = 18;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.gridwidth = 0;
        this.c.insets = new Insets(11, 11, 11, 11);
        this.contentPanel = new JPanel(this.layout);
        this.layout.setConstraints(this.mainPanel, this.c);
        this.contentPanel.add(this.mainPanel);
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.setSize(Math.max(640, (int)(0.66 * (double)this.getOwner().getWidth())), Math.max(480, (int)(0.66 * (double)this.getOwner().getHeight())));
        this.setLocationRelativeTo(this.getOwner());
    }

    public boolean validateCurrentStep(int currentStep, int newStep) {
        return true;
    }

    protected abstract void performStepAction(int var1, int var2);

    protected abstract void finish(ConfigurationListener var1);

    protected void addBottomComponent(Component bottomComponent) {
        this.c.weighty = 2.0;
        this.layout.setConstraints(bottomComponent, this.c);
        this.contentPanel.add(bottomComponent);
    }

    protected int getNumberOfSteps() {
        return this.numberOfSteps;
    }

    protected void addStep(Component c) {
        this.mainPanel.add(c, this.numberOfSteps + "");
        ++this.numberOfSteps;
    }

    private void step(int dir) {
        int oldStep = this.currentStep;
        this.currentStep += dir;
        if (this.validateCurrentStep(oldStep, this.currentStep)) {
            if (this.currentStep < 0) {
                this.currentStep = 0;
            }
            if (this.currentStep == 0) {
                this.previous.setEnabled(false);
            } else {
                this.previous.setEnabled(true);
            }
            if (this.currentStep >= this.numberOfSteps) {
                this.currentStep = this.numberOfSteps - 1;
                this.finish(this.listener);
            }
            this.cardLayout.show(this.mainPanel, this.currentStep + "");
            this.performStepAction(this.currentStep, oldStep);
        } else {
            this.currentStep = oldStep;
        }
    }

    protected void cancel() {
        this.dispose();
    }

    private class NextButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        public NextButton() {
            super(DUMMY_NEXT_ACTION);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NextButton.this.step();
                }
            });
        }

        private void step() {
            AbstractConfigurationWizard.this.step(1);
            this.updateContent();
        }

        private void updateContent() {
            if (AbstractConfigurationWizard.this.currentStep == AbstractConfigurationWizard.this.numberOfSteps - 1) {
                this.configurePropertiesFromAction(DUMMY_FINISH_ACTION);
            } else {
                this.configurePropertiesFromAction(DUMMY_NEXT_ACTION);
            }
        }
    }
}

