/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer.collection;

import com.rapidminer.gui.processeditor.results.ResultDisplayTools;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.viewer.collection.CollectionTreeCellRenderer;
import com.rapidminer.gui.viewer.collection.CollectionTreeModel;
import com.rapidminer.operator.GroupedModel;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.operator.learner.meta.MetaModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class CollectionViewer
extends JPanel {
    private static final long serialVersionUID = -322963469866592863L;
    private Component current;
    private final IOObject collection;

    public CollectionViewer(GroupedModel model, IOContainer container) {
        this((IOObject)model, container);
    }

    public CollectionViewer(MetaModel model, IOContainer container) {
        this((IOObject)((Object)model), container);
    }

    public CollectionViewer(IOObjectCollection<IOObject> collection, IOContainer container) {
        this((IOObject)collection, container);
    }

    private CollectionViewer(IOObject collection, IOContainer container) {
        this.collection = collection;
        this.constructPanel(container);
    }

    private void constructPanel(final IOContainer container) {
        int size;
        this.current = null;
        this.setLayout(new BorderLayout());
        IOObject first = null;
        if (this.collection instanceof GroupedModel) {
            size = ((GroupedModel)this.collection).getNumberOfModels();
            if (size > 0) {
                first = ((GroupedModel)this.collection).getModel(0);
            }
        } else if (this.collection instanceof MetaModel) {
            size = ((MetaModel)((Object)this.collection)).getModels().size();
            if (size > 0) {
                first = ((MetaModel)((Object)this.collection)).getModels().get(0);
            }
        } else if (this.collection instanceof IOObjectCollection) {
            size = ((IOObjectCollection)this.collection).size();
            if (size > 0) {
                first = ((IOObjectCollection)this.collection).getElement(0, false);
            }
        } else {
            size = 1;
            first = this.collection;
        }
        switch (size) {
            case 0: {
                this.current = new JLabel("No elements in this collection");
                this.add(this.current, "Center");
                break;
            }
            case 1: {
                Model currentObject = first;
                this.current = ResultDisplayTools.createVisualizationComponent(currentObject, container, currentObject instanceof ResultObject ? ((ResultObject)currentObject).getName() : currentObject.getClass().getName());
                this.add(this.current, "Center");
                break;
            }
            default: {
                JTree tree = new JTree(new CollectionTreeModel(this.collection));
                tree.setCellRenderer(new CollectionTreeCellRenderer(this.collection));
                tree.addTreeSelectionListener(new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent e) {
                        if (e.getPath() != null && e.getPath().getLastPathComponent() != null) {
                            IOObject currentObject;
                            if (CollectionViewer.this.current != null) {
                                CollectionViewer.this.remove(CollectionViewer.this.current);
                            }
                            if (!((currentObject = (IOObject)e.getPath().getLastPathComponent()) == CollectionViewer.this.collection || currentObject instanceof IOObjectCollection || currentObject instanceof GroupedModel || currentObject instanceof MetaModel)) {
                                CollectionViewer.this.current = ResultDisplayTools.createVisualizationComponent(currentObject, container, currentObject instanceof ResultObject ? ((ResultObject)currentObject).getName() : currentObject.getClass().getName());
                            } else {
                                CollectionViewer.this.current = new ResourceLabel("collectionviewer.select_leaf", new Object[0]);
                                ((JLabel)CollectionViewer.this.current).setVerticalAlignment(1);
                                ((JLabel)CollectionViewer.this.current).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                            }
                            CollectionViewer.this.add(CollectionViewer.this.current, "Center");
                            CollectionViewer.this.revalidate();
                        }
                    }
                });
                ExtendedJScrollPane listScrollPane = new ExtendedJScrollPane(tree);
                listScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.LIGHT_GRAY));
                this.add((Component)listScrollPane, "West");
                tree.setSelectionRow(0);
            }
        }
    }
}

