/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer.collection;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.operator.learner.meta.MetaModel;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class CollectionTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private final Icon ICON_FOLDER_OPEN = SwingTools.createIcon("16/folder.png");
    private final Icon ICON_FOLDER_CLOSED = SwingTools.createIcon("16/folder_closed.png");
    private final Map<IOObject, String> childNames = new HashMap<IOObject, String>();

    public CollectionTreeCellRenderer(IOObject collection) {
        if (collection instanceof MetaModel) {
            MetaModel mm = (MetaModel)((Object)collection);
            for (int i = 0; i < mm.getModels().size(); ++i) {
                this.childNames.put(mm.getModels().get(i), mm.getModelNames().get(i));
            }
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof ResultObject) {
            ResultObject ro = (ResultObject)value;
            String name = this.childNames.get(ro);
            if (name == null) {
                name = ro.getName();
            }
            label.setText("<html>" + name + " (<small>" + ro.getSource() + "</small>)</html>");
            if (ro instanceof IOObjectCollection) {
                label.setIcon(expanded ? this.ICON_FOLDER_OPEN : this.ICON_FOLDER_CLOSED);
            } else {
                Icon resultIcon = ro.getResultIcon();
                label.setIcon(resultIcon);
            }
        } else if (value instanceof IOObject) {
            IOObject ioo = (IOObject)value;
            label.setText(ioo.getClass().getSimpleName());
        }
        return label;
    }
}

