/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import javax.swing.table.AbstractTableModel;

public class SimilarityTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7451178433975831387L;
    private static final int COLUMN_FIRST = 0;
    private static final int COLUMN_SECOND = 1;
    private static final int COLUMN_SIMILARITY = 2;
    private DistanceMeasure similarity;
    private ExampleSet exampleSet;
    private Attribute idAttribute;

    public SimilarityTableModel(DistanceMeasure similarity, ExampleSet exampleSet) {
        this.similarity = similarity;
        this.exampleSet = exampleSet;
        this.idAttribute = exampleSet.getAttributes().getId();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "First";
            }
            case 1: {
                return "Second";
            }
            case 2: {
                if (this.similarity.isDistance()) {
                    return "Distance";
                }
                return "Similarity";
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column == 2) {
            return Double.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        int n = this.exampleSet.size();
        return (n - 1) * n / 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int[] actualRows = this.getActualRows(rowIndex);
        Example first = this.exampleSet.getExample(actualRows[0]);
        Example second = this.exampleSet.getExample(actualRows[1]);
        switch (columnIndex) {
            case 0: {
                return first.getValueAsString(this.idAttribute);
            }
            case 1: {
                return second.getValueAsString(this.idAttribute);
            }
            case 2: {
                if (this.similarity.isDistance()) {
                    return this.similarity.calculateDistance(first, second);
                }
                return this.similarity.calculateSimilarity(first, second);
            }
        }
        return "?";
    }

    private int[] getActualRows(int rowIndex) {
        int sum = 0;
        int currentLength = this.exampleSet.size() - 1;
        int result = 0;
        while (sum + currentLength <= rowIndex) {
            sum += currentLength;
            --currentLength;
            ++result;
        }
        return new int[]{result, this.exampleSet.size() - (sum + currentLength - rowIndex)};
    }
}

