/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.gui.processeditor.results.ResultDisplayTools;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PerformanceVectorViewer
extends JPanel {
    private static final long serialVersionUID = -5848837142789453985L;

    public PerformanceVectorViewer(PerformanceVector performanceVector, IOContainer container) {
        this.setLayout(new BorderLayout());
        final CardLayout cardLayout = new CardLayout();
        final JPanel mainPanel = new JPanel(cardLayout);
        this.add((Component)mainPanel, "Center");
        LinkedList<String> criteriaNameList = new LinkedList<String>();
        for (int i = 0; i < performanceVector.getSize(); ++i) {
            PerformanceCriterion criterion = performanceVector.getCriterion(i);
            criteriaNameList.add(criterion.getName());
            JPanel component = ResultDisplayTools.createVisualizationComponent(criterion, container, "Performance Criterion");
            ExtendedJScrollPane criterionPane = new ExtendedJScrollPane(component);
            criterionPane.setBorder(null);
            mainPanel.add((Component)criterionPane, criterion.getName());
        }
        Object[] criteriaNames = new String[criteriaNameList.size()];
        criteriaNameList.toArray(criteriaNames);
        final JList criteriaList = new JList(criteriaNames){
            private static final long serialVersionUID = 3031125186920370793L;

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = Math.max(150, dim.width);
                return dim;
            }
        };
        criteriaList.setBorder(BorderFactory.createTitledBorder("Criterion Selector"));
        criteriaList.setSelectionMode(0);
        criteriaList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String selected = (String)criteriaList.getSelectedValue();
                cardLayout.show(mainPanel, selected);
            }
        });
        ExtendedJScrollPane listScrollPane = new ExtendedJScrollPane(criteriaList);
        listScrollPane.setBorder(null);
        this.add((Component)listScrollPane, "West");
        criteriaList.setSelectedIndices(new int[]{0});
    }
}

