/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.tools.CellColorProvider;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.ExtendedJTableSorterModel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.viewer.MetaDataViewerTableModel;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;

public class MetaDataViewerTable
extends ExtendedJTable {
    private static final int MAXIMAL_CONTENT_LENGTH = 200;
    private static final long serialVersionUID = -4879028136543294746L;
    private int numberOfSpecialAttributeRows = 0;
    private MetaDataViewerTableModel model = null;

    public MetaDataViewerTable() {
        this.setCellColorProvider(new CellColorProvider(){

            @Override
            public Color getCellColor(int row, int col) {
                int actualRowIndex = ((ExtendedJTableSorterModel)MetaDataViewerTable.this.getModel()).modelIndex(row);
                if (actualRowIndex < MetaDataViewerTable.this.numberOfSpecialAttributeRows) {
                    return SwingTools.LIGHTEST_YELLOW;
                }
                if (row % 2 == 0) {
                    return Color.WHITE;
                }
                return SwingTools.LIGHTEST_BLUE;
            }
        });
        this.setCutOnLineBreak(false);
        this.setMaximalTextLength(200);
    }

    public MetaDataViewerTable(ExampleSet exampleSet) {
        this();
        this.setExampleSet(exampleSet);
    }

    public void setExampleSet(ExampleSet exampleSet) {
        this.model = new MetaDataViewerTableModel(exampleSet);
        this.setModel(this.model);
        this.numberOfSpecialAttributeRows = exampleSet != null ? exampleSet.getAttributes().specialSize() : 0;
    }

    public MetaDataViewerTableModel getMetaDataModel() {
        return this.model;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realColumnIndex = MetaDataViewerTable.this.convertColumnIndexToModel(index);
                return MetaDataViewerTable.this.model.getColumnToolTip(realColumnIndex);
            }
        };
    }
}

