/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.ViewToolBar;
import com.rapidminer.gui.tools.components.DropDownButton;
import com.rapidminer.gui.viewer.MetaDataViewerTable;
import com.rapidminer.gui.viewer.MetaDataViewerTableModel;
import com.rapidminer.report.Tableable;
import com.rapidminer.tools.ProgressListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class MetaDataViewer
extends JPanel
implements Tableable {
    private static final long serialVersionUID = 5466205420267797125L;
    private JLabel generalInfo = new JLabel();
    private MetaDataViewerTable metaDataTable;

    public MetaDataViewer(ExampleSet exampleSet, boolean showOptions) {
        super(new BorderLayout());
        this.generalInfo.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.metaDataTable = new MetaDataViewerTable();
        ViewToolBar toolBar = new ViewToolBar();
        toolBar.add((Component)this.generalInfo, 0);
        if (showOptions) {
            DropDownButton button = new DropDownButton(new ResourceAction(true, "select_columns", new Object[0]){
                private static final long serialVersionUID = -6470766941799410502L;

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            }){
                private static final long serialVersionUID = 8545784128784421566L;

                @Override
                protected JPopupMenu getPopupMenu() {
                    JPopupMenu menu = new JPopupMenu();
                    for (int i = 0; i < MetaDataViewerTableModel.COLUMN_NAMES.length; ++i) {
                        menu.add(new ToggleShowColumnItem(MetaDataViewerTableModel.COLUMN_NAMES[i], i, MetaDataViewer.this.metaDataTable.getMetaDataModel().getShowColumn(i), MetaDataViewer.this.metaDataTable));
                    }
                    return menu;
                }
            };
            button.addToToolBar(toolBar, 1);
            ResourceAction calculateStatisticsAction = new ResourceAction(true, "calculate_statistics", new Object[0]){
                private static final long serialVersionUID = 8763079896628342561L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProgressThread t = new ProgressThread("calculate_statistics"){

                        @Override
                        public void run() {
                            ProgressListener l = this.getProgressListener();
                            l.setTotal(100);
                            l.setCompleted(10);
                            MetaDataViewer.this.metaDataTable.getMetaDataModel().calculateStatistics();
                            l.setCompleted(100);
                        }
                    };
                    t.start();
                }
            };
            toolBar.add(calculateStatisticsAction, 1);
        }
        this.add((Component)toolBar, "North");
        ExtendedJScrollPane tableScrollPane = new ExtendedJScrollPane(this.metaDataTable);
        tableScrollPane.setBorder(null);
        this.add((Component)tableScrollPane, "Center");
        this.setExampleSet(exampleSet);
    }

    public void setExampleSet(ExampleSet exampleSet) {
        if (exampleSet != null) {
            StringBuffer infoText = new StringBuffer("ExampleSet (");
            int noExamples = exampleSet.size();
            infoText.append(noExamples);
            infoText.append(noExamples == 1 ? " example, " : " examples, ");
            int noSpecial = exampleSet.getAttributes().specialSize();
            infoText.append(noSpecial);
            infoText.append(noSpecial == 1 ? " special attribute, " : " special attributes, ");
            int noRegular = exampleSet.getAttributes().size();
            infoText.append(noRegular);
            infoText.append(noRegular == 1 ? " regular attribute)" : " regular attributes)");
            this.generalInfo.setText(infoText.toString());
            this.metaDataTable.setExampleSet(exampleSet);
        } else {
            this.generalInfo.setText("no examples");
            this.metaDataTable.setExampleSet(null);
        }
    }

    @Override
    public void prepareReporting() {
        this.metaDataTable.prepareReporting();
    }

    @Override
    public void finishReporting() {
        this.metaDataTable.finishReporting();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.metaDataTable.getColumnName(columnIndex);
    }

    @Override
    public String getCell(int row, int column) {
        return this.metaDataTable.getCell(row, column);
    }

    @Override
    public int getColumnNumber() {
        return this.metaDataTable.getColumnNumber();
    }

    @Override
    public int getRowNumber() {
        return this.metaDataTable.getRowNumber();
    }

    @Override
    public boolean isFirstLineHeader() {
        return false;
    }

    @Override
    public boolean isFirstColumnHeader() {
        return false;
    }

    private static class ToggleShowColumnItem
    extends JCheckBoxMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 570766967933245379L;
        private int index;
        private MetaDataViewerTable metaDataTable;

        ToggleShowColumnItem(String name, int index, boolean state, MetaDataViewerTable metaDataTable) {
            super("Show column '" + name + "'", state);
            this.setToolTipText("Toggles if the column with name '" + name + "' should be displayed");
            this.setIcon(SwingTools.createIcon("16/table_column.png"));
            this.addActionListener(this);
            this.index = index;
            this.metaDataTable = metaDataTable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.metaDataTable.getMetaDataModel().setShowColumn(this.index, this.isSelected());
        }
    }
}

