/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.viewer.FrequentItemSetsTableModel;
import com.rapidminer.operator.learner.associations.FrequentItemSets;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrequentItemSetVisualization
extends JPanel {
    private static final long serialVersionUID = -4353590225271845908L;
    private FrequentItemSetsTableModel model;
    private JLabel totalSizeLabel = new JLabel();
    private JLabel minItemSetSizeLabel = new JLabel();

    public FrequentItemSetVisualization(final FrequentItemSets frequentSets) {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        mainPanel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        if (frequentSets.size() == 0) {
            JLabel emptyLabel = new JLabel("no itemsets found");
            JPanel emptyPanel = new JPanel(new FlowLayout(1));
            emptyPanel.add(emptyLabel);
            layout.setConstraints(emptyPanel, c);
            mainPanel.add(emptyPanel);
        } else {
            frequentSets.sortSets();
            this.model = new FrequentItemSetsTableModel(frequentSets);
            ExtendedJTable table = new ExtendedJTable(this.model, true, true, false);
            ExtendedJScrollPane tablePane = new ExtendedJScrollPane(table);
            layout.setConstraints(tablePane, c);
            mainPanel.add(tablePane);
        }
        this.add((Component)mainPanel, "Center");
        GridBagLayout layout2 = new GridBagLayout();
        JPanel controlPanel = new JPanel(layout2);
        c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(4, 4, 4, 4);
        c.gridwidth = 0;
        this.totalSizeLabel.setText("No. of Sets: " + frequentSets.size());
        layout2.setConstraints(this.totalSizeLabel, c);
        controlPanel.add(this.totalSizeLabel);
        this.minItemSetSizeLabel.setText("Total Max. Size: " + frequentSets.getMaximumSetSize());
        layout2.setConstraints(this.minItemSetSizeLabel, c);
        controlPanel.add(this.minItemSetSizeLabel);
        Component strut = Box.createVerticalStrut(10);
        layout2.setConstraints(strut, c);
        controlPanel.add(strut);
        JLabel label = new JLabel("Min. Size: ");
        c.gridwidth = -1;
        layout2.setConstraints(label, c);
        controlPanel.add(label);
        final JTextField minSizeField = new JTextField(4);
        minSizeField.setText("1");
        c.gridwidth = 0;
        layout2.setConstraints(minSizeField, c);
        controlPanel.add(minSizeField);
        label = new JLabel("Max. Size: ");
        c.gridwidth = -1;
        layout2.setConstraints(label, c);
        controlPanel.add(label);
        final JTextField maxSizeField = new JTextField(4);
        maxSizeField.setText(frequentSets.getMaximumSetSize() + "");
        c.gridwidth = 0;
        layout2.setConstraints(maxSizeField, c);
        controlPanel.add(maxSizeField);
        label = new JLabel("Contains Item: ");
        c.gridwidth = 0;
        layout2.setConstraints(label, c);
        controlPanel.add(label);
        final JTextField itemNameField = new JTextField(8);
        c.gridwidth = 0;
        layout2.setConstraints(itemNameField, c);
        controlPanel.add(itemNameField);
        JButton updateButton = new JButton("Update View");
        c.gridwidth = 0;
        layout2.setConstraints(updateButton, c);
        controlPanel.add(updateButton);
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String searchString;
                int minNumber = 1;
                String minText = minSizeField.getText();
                if (minText != null && minText.trim().length() >= 0) {
                    try {
                        minNumber = Integer.parseInt(minText);
                    }
                    catch (NumberFormatException ex) {
                        SwingTools.showVerySimpleErrorMessage("only_num_values_for_min_nr_of_items", new Object[0]);
                        return;
                    }
                }
                int maxNumber = frequentSets.getMaximumSetSize();
                String maxText = maxSizeField.getText();
                if (maxText != null && maxText.trim().length() >= 0) {
                    try {
                        maxNumber = Integer.parseInt(maxText);
                    }
                    catch (NumberFormatException ex) {
                        SwingTools.showVerySimpleErrorMessage("only_num_values_for_min_nr_of_items", new Object[0]);
                        return;
                    }
                }
                if ((searchString = itemNameField.getText()) != null && searchString.trim().length() == 0) {
                    searchString = null;
                }
                if (FrequentItemSetVisualization.this.model != null) {
                    FrequentItemSetVisualization.this.model.updateFilter(minNumber, maxNumber, searchString);
                    FrequentItemSetVisualization.this.totalSizeLabel.setText("No. of Sets: " + FrequentItemSetVisualization.this.model.getRowCount());
                    FrequentItemSetVisualization.this.minItemSetSizeLabel.setText("Total Max. Size: " + (FrequentItemSetVisualization.this.model.getColumnCount() - 2));
                }
            }
        });
        JPanel fillPanel = new JPanel();
        c.gridwidth = 0;
        c.weighty = 1.0;
        layout2.setConstraints(fillPanel, c);
        controlPanel.add(fillPanel);
        this.add((Component)controlPanel, "West");
    }
}

