/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Ontology;
import java.util.Date;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;

public class DataViewerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3057324874942971672L;
    private Attribute[] regularAttributes;
    private Attribute[] specialAttributes;
    private ExampleSet exampleSet;

    public DataViewerTableModel(ExampleSet exampleSet) {
        this.exampleSet = exampleSet;
        this.regularAttributes = new Attribute[exampleSet.getAttributes().size()];
        Iterator<Attribute> r = exampleSet.getAttributes().iterator();
        int counter = 0;
        while (r.hasNext()) {
            this.regularAttributes[counter++] = r.next();
        }
        this.specialAttributes = new Attribute[exampleSet.getAttributes().specialSize()];
        Iterator<AttributeRole> s = exampleSet.getAttributes().specialAttributes();
        counter = 0;
        while (s.hasNext()) {
            this.specialAttributes[counter++] = s.next().getAttribute();
        }
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class<Object> type = super.getColumnClass(column);
        if (column == 0) {
            type = Integer.class;
        } else {
            int col = column - 1;
            Attribute attribute = null;
            attribute = col < this.specialAttributes.length ? this.specialAttributes[col] : this.regularAttributes[col - this.specialAttributes.length];
            type = Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9) ? Date.class : (!attribute.isNominal() ? Double.class : String.class);
        }
        return type;
    }

    @Override
    public int getRowCount() {
        return this.exampleSet.size();
    }

    @Override
    public int getColumnCount() {
        return this.specialAttributes.length + this.regularAttributes.length + 1;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return row + 1;
        }
        int col = column - 1;
        Example example = this.exampleSet.getExample(row);
        if (example != null) {
            if (col < this.specialAttributes.length) {
                return this.getValueWithCorrectClass(example, this.specialAttributes[col]);
            }
            return this.getValueWithCorrectClass(example, this.regularAttributes[col - this.specialAttributes.length]);
        }
        return null;
    }

    private Object getValueWithCorrectClass(Example example, Attribute attribute) {
        try {
            double value = example.getValue(attribute);
            if (Double.isNaN(value)) {
                return "?";
            }
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
                return new Date((long)value);
            }
            if (attribute.isNumerical()) {
                return example.getValue(attribute);
            }
            return example.getValueAsString(attribute, -1, false);
        }
        catch (Throwable e) {
            LogService.getGlobal().logWarning("Cannot show correct value: " + e.getMessage());
            return "Error";
        }
    }

    @Override
    public String getColumnName(int column) {
        if (column < 0) {
            return "";
        }
        if (column == 0) {
            return "Row No.";
        }
        int col = column - 1;
        if (col < this.specialAttributes.length) {
            return this.specialAttributes[col].getName();
        }
        return this.regularAttributes[col - this.specialAttributes.length].getName();
    }
}

