/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.tools.CellColorProvider;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.viewer.DataViewerTableModel;
import com.rapidminer.tools.Ontology;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.table.JTableHeader;

public class DataViewerTable
extends ExtendedJTable {
    private static final int MAXIMAL_CONTENT_LENGTH = 200;
    private static final long serialVersionUID = 5535239693801265693L;
    private int numberOfSpecialAttributes = 0;
    private int[] dateColumns;

    public DataViewerTable() {
        this.setAutoResizeMode(0);
        this.setFixFirstColumnForRearranging(true);
    }

    public void setExampleSet(ExampleSet exampleSet) {
        this.setModel(new DataViewerTableModel(exampleSet));
        this.numberOfSpecialAttributes = exampleSet.getAttributes().specialSize();
        this.dateColumns = new int[exampleSet.getAttributes().allSize() + 1];
        this.dateColumns[0] = -1;
        int index = 1;
        Iterator<AttributeRole> s = exampleSet.getAttributes().specialAttributes();
        while (s.hasNext()) {
            Attribute attribute = s.next().getAttribute();
            this.dateColumns[index] = Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 10) ? 0 : (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 11) ? 1 : (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9) ? 2 : -1));
            ++index;
        }
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.dateColumns[index] = Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 10) ? 0 : (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 11) ? 1 : (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9) ? 2 : -1));
            ++index;
        }
        this.setCellColorProvider(new CellColorProvider(){

            @Override
            public Color getCellColor(int row, int column) {
                int col = DataViewerTable.this.convertColumnIndexToModel(column);
                if (col > 0 && col < DataViewerTable.this.numberOfSpecialAttributes + 1) {
                    if (row % 2 == 0) {
                        return Color.WHITE;
                    }
                    return SwingTools.LIGHTEST_YELLOW;
                }
                if (row % 2 == 0) {
                    return Color.WHITE;
                }
                return SwingTools.LIGHTEST_BLUE;
            }
        });
        this.setCutOnLineBreak(true);
        this.setMaximalTextLength(200);
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realColumnIndex = DataViewerTable.this.convertColumnIndexToModel(index);
                return DataViewerTable.this.getHeaderToolTipText(realColumnIndex);
            }
        };
    }

    private String getHeaderToolTipText(int realColumnIndex) {
        if (realColumnIndex == 0) {
            return "The position of the example in the (filtered) view on the example table.";
        }
        return "The data for the attribute '" + this.getModel().getColumnName(realColumnIndex) + "'.";
    }

    @Override
    public int getDateFormat(int row, int column) {
        return this.dateColumns[column];
    }
}

