/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Condition;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.example.set.ConditionedExampleSet;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ViewToolBar;
import com.rapidminer.gui.viewer.DataViewerTable;
import com.rapidminer.report.Tableable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DataViewer
extends JPanel
implements Tableable {
    private static final long serialVersionUID = -8114228636932871865L;
    private static final int DEFAULT_MAX_SIZE_FOR_FILTERING = 100000;
    private JLabel generalInfo = new JLabel();
    private DataViewerTable dataTable;
    private JLabel filterCounter;
    private transient ExampleSet originalExampleSet;

    public DataViewer(ExampleSet exampleSet, boolean providedFilter) {
        super(new BorderLayout());
        this.generalInfo.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.dataTable = new DataViewerTable();
        this.filterCounter = new JLabel();
        this.originalExampleSet = exampleSet;
        ViewToolBar toolBar = new ViewToolBar();
        StringBuffer infoText = new StringBuffer("ExampleSet (");
        int noExamples = this.originalExampleSet.size();
        infoText.append(noExamples);
        infoText.append(noExamples == 1 ? " example, " : " examples, ");
        int noSpecial = this.originalExampleSet.getAttributes().specialSize();
        infoText.append(noSpecial);
        infoText.append(noSpecial == 1 ? " special attribute, " : " special attributes, ");
        int noRegular = this.originalExampleSet.getAttributes().size();
        infoText.append(noRegular);
        infoText.append(noRegular == 1 ? " regular attribute)" : " regular attributes)");
        this.generalInfo.setText(infoText.toString());
        toolBar.add((Component)this.generalInfo, 0);
        if (providedFilter) {
            toolBar.add((Component)new JLabel("View Filter "), 1);
            this.updateFilterCounter(this.originalExampleSet);
            toolBar.add((Component)this.filterCounter, 1);
            LinkedList<String> applicableFilterNames = new LinkedList<String>();
            for (int i = 0; i < ConditionedExampleSet.KNOWN_CONDITION_NAMES.length; ++i) {
                String conditionName = ConditionedExampleSet.KNOWN_CONDITION_NAMES[i];
                try {
                    ConditionedExampleSet.createCondition(conditionName, exampleSet, null);
                    applicableFilterNames.add(conditionName);
                    continue;
                }
                catch (ConditionCreationException ex) {
                    // empty catch block
                }
            }
            String[] applicableConditions = new String[applicableFilterNames.size()];
            applicableFilterNames.toArray(applicableConditions);
            final JComboBox<String> filterSelector = new JComboBox<String>(applicableConditions);
            filterSelector.setToolTipText("These filters can be used to skip examples in the view fulfilling the filter condition.");
            filterSelector.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DataViewer.this.updateFilter((String)filterSelector.getSelectedItem());
                }
            });
            int maxNumberBeforeFiltering = 100000;
            String maxString = System.getProperty("rapidminer.gui.max_statistics_rows");
            if (maxString != null) {
                try {
                    maxNumberBeforeFiltering = Integer.parseInt(maxString);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (exampleSet.size() > maxNumberBeforeFiltering) {
                filterSelector.setEnabled(false);
            }
            toolBar.add((Component)filterSelector, 1);
            toolBar.setPreferredSize(new Dimension(this.getWidth(), 29));
        }
        this.add((Component)toolBar, "North");
        ExtendedJScrollPane tableScrollPane = new ExtendedJScrollPane(this.dataTable);
        tableScrollPane.setBorder(null);
        this.add((Component)tableScrollPane, "Center");
        this.setExampleSet(exampleSet);
    }

    public void setExampleSet(ExampleSet exampleSet) {
        this.dataTable.setExampleSet(exampleSet);
    }

    private void updateFilter(String conditionName) {
        ExampleSet filteredExampleSet = this.originalExampleSet;
        try {
            Condition condition = ConditionedExampleSet.createCondition(conditionName, this.originalExampleSet, null);
            filteredExampleSet = new ConditionedExampleSet(this.originalExampleSet, condition);
        }
        catch (ConditionCreationException ex) {
            this.originalExampleSet.getLog().logError("Cannot create condition '" + conditionName + "' for filtered data view: " + ex.getMessage() + ". Using original data set view...");
            filteredExampleSet = this.originalExampleSet;
        }
        this.updateFilterCounter(filteredExampleSet);
        this.setExampleSet(filteredExampleSet);
    }

    private void updateFilterCounter(ExampleSet filteredExampleSet) {
        this.filterCounter.setText("(" + filteredExampleSet.size() + " / " + this.originalExampleSet.size() + "): ");
    }

    @Override
    public void prepareReporting() {
        this.dataTable.prepareReporting();
    }

    @Override
    public void finishReporting() {
        this.dataTable.finishReporting();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.dataTable.getColumnName(columnIndex);
    }

    @Override
    public String getCell(int row, int column) {
        return this.dataTable.getCell(row, column);
    }

    @Override
    public int getColumnNumber() {
        return this.dataTable.getColumnNumber();
    }

    @Override
    public int getRowNumber() {
        return this.dataTable.getRowNumber();
    }

    @Override
    public boolean isFirstLineHeader() {
        return false;
    }

    @Override
    public boolean isFirstColumnHeader() {
        return false;
    }
}

