/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableListener;
import com.rapidminer.gui.tools.CellColorProvider;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.viewer.DataTableViewerTableModel;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;

public class DataTableViewerTable
extends ExtendedJTable
implements DataTableListener {
    private static final long serialVersionUID = 3206734427933036268L;
    public static final int ALTERNATING = 0;
    public static final int SCALED = 1;
    public static final int ABS_SCALED = 2;
    private int rendererType = 0;
    private double min = 0.0;
    private double max = 0.0;
    private DataTableViewerTableModel model;

    public DataTableViewerTable(boolean autoResize) {
        this((DataTable)null, true, false, autoResize);
    }

    public DataTableViewerTable(DataTable dataTable, boolean sortable, boolean columnMovable, boolean autoResize) {
        super(sortable, columnMovable, autoResize);
        if (dataTable != null) {
            this.setDataTable(dataTable);
        }
        this.setCellColorProvider(new CellColorProvider(){

            @Override
            public Color getCellColor(int row, int col) {
                switch (DataTableViewerTable.this.rendererType) {
                    case 0: {
                        if (row % 2 == 0) {
                            return Color.WHITE;
                        }
                        return SwingTools.LIGHTEST_BLUE;
                    }
                }
                Object valueObject = DataTableViewerTable.this.getValueAt(row, col);
                try {
                    double value = Double.parseDouble(valueObject.toString());
                    if (DataTableViewerTable.this.rendererType == 2) {
                        value = Math.abs(value);
                    }
                    float scaled = (float)((value - DataTableViewerTable.this.min) / (DataTableViewerTable.this.max - DataTableViewerTable.this.min));
                    Color color = new Color(1.0f - scaled * 0.2f, 1.0f - scaled * 0.2f, 1.0f);
                    return color;
                }
                catch (NumberFormatException e) {
                    return Color.WHITE;
                }
            }
        });
    }

    @Override
    public void dataTableUpdated(DataTable source) {
        if (this.model != null) {
            this.model.fireTableDataChanged();
        }
    }

    public void setDataTable(DataTable dataTable) {
        this.model = new DataTableViewerTableModel(dataTable);
        this.setModel(this.model);
        if (this.rendererType != 0) {
            this.recalculateStatistics();
        }
        dataTable.addDataTableListener(this);
    }

    public void setRendererType(int rendererType) {
        this.rendererType = rendererType;
        if (rendererType != 0) {
            this.recalculateStatistics();
        }
    }

    private void recalculateStatistics() {
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        for (int x = 0; x < this.getRowCount(); ++x) {
            for (int y = 0; y < this.getColumnCount(); ++y) {
                Object valueObject = this.getValueAt(x, y);
                double value = Double.NaN;
                try {
                    value = Double.parseDouble(valueObject.toString());
                    if (this.rendererType == 2) {
                        value = Math.abs(value);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (Double.isNaN(value)) continue;
                this.min = Math.min(this.min, value);
                this.max = Math.max(this.max, value);
            }
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realColumnIndex = DataTableViewerTable.this.convertColumnIndexToModel(index);
                if (realColumnIndex >= 0 && realColumnIndex < DataTableViewerTable.this.getModel().getColumnCount()) {
                    return "The column " + DataTableViewerTable.this.getModel().getColumnName(realColumnIndex);
                }
                return "";
            }
        };
    }
}

