/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableListener;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.PlotterPanel;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.viewer.DataTableViewerTable;
import com.rapidminer.report.Tableable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DataTableViewer
extends JPanel
implements Tableable,
DataTableListener {
    private static final long serialVersionUID = 6878549119308753961L;
    public static final int TABLE_MODE = 0;
    public static final int PLOT_MODE = 1;
    private JLabel generalInfo = new JLabel();
    private DataTableViewerTable dataTableViewerTable;
    private PlotterPanel plotterPanel;
    private PlotterConfigurationModel plotterSettings;

    public DataTableViewer(DataTable dataTable) {
        this(dataTable, PlotterConfigurationModel.DATA_SET_PLOTTER_SELECTION, true, 0, false);
    }

    public DataTableViewer(DataTable dataTable, boolean showPlotter) {
        this(dataTable, PlotterConfigurationModel.DATA_SET_PLOTTER_SELECTION, showPlotter, 0, false);
    }

    public DataTableViewer(DataTable dataTable, boolean showPlotter, int startMode) {
        this(dataTable, PlotterConfigurationModel.DATA_SET_PLOTTER_SELECTION, showPlotter, startMode, false);
    }

    public DataTableViewer(DataTable dataTable, LinkedHashMap<String, Class<? extends Plotter>> availablePlotters) {
        this(dataTable, availablePlotters, true, 0, false);
    }

    public DataTableViewer(DataTable dataTable, LinkedHashMap<String, Class<? extends Plotter>> availablePlotters, boolean showPlotter, int startMode, boolean autoResize) {
        super(new BorderLayout());
        this.dataTableViewerTable = new DataTableViewerTable(autoResize);
        final JPanel tablePanel = new JPanel(new BorderLayout());
        JPanel infoPanel = new JPanel(new FlowLayout(0));
        infoPanel.add(this.generalInfo);
        tablePanel.add((Component)infoPanel, "North");
        ExtendedJScrollPane tableScrollPane = new ExtendedJScrollPane(this.dataTableViewerTable);
        tablePanel.add((Component)tableScrollPane, "Center");
        this.add(tablePanel);
        if (showPlotter) {
            this.plotterSettings = new PlotterConfigurationModel(availablePlotters, dataTable);
            this.plotterPanel = new PlotterPanel(this.plotterSettings);
            final JRadioButton tableButton = new JRadioButton("Table View", true);
            tableButton.setToolTipText("Toggles to the table view of this model data.");
            tableButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (tableButton.isSelected()) {
                        DataTableViewer.this.remove(DataTableViewer.this.plotterPanel);
                        DataTableViewer.this.add((Component)tablePanel, "Center");
                        DataTableViewer.this.repaint();
                    }
                }
            });
            final JRadioButton plotButton = new JRadioButton("Plot View", false);
            plotButton.setToolTipText("Toggles to the plotter view of this model.");
            plotButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (plotButton.isSelected()) {
                        DataTableViewer.this.remove(tablePanel);
                        DataTableViewer.this.add((Component)DataTableViewer.this.plotterPanel, "Center");
                        DataTableViewer.this.repaint();
                    }
                }
            });
            ButtonGroup group = new ButtonGroup();
            group.add(tableButton);
            group.add(plotButton);
            JPanel togglePanel = new JPanel(new FlowLayout(0));
            togglePanel.add(tableButton);
            togglePanel.add(plotButton);
            this.add((Component)togglePanel, "North");
            switch (startMode) {
                case 0: {
                    this.add(tablePanel);
                    tableButton.setSelected(true);
                    break;
                }
                case 1: {
                    this.add(this.plotterPanel);
                    plotButton.setSelected(true);
                }
            }
        }
        this.setDataTable(dataTable);
    }

    public DataTable getDataTable() {
        return this.plotterSettings.getDataTable();
    }

    public PlotterPanel getPlotterPanel() {
        return this.plotterPanel;
    }

    public DataTableViewerTable getTable() {
        return this.dataTableViewerTable;
    }

    public void setDataTable(DataTable dataTable) {
        this.dataTableViewerTable.setDataTable(dataTable);
        if (this.plotterSettings != null) {
            this.plotterSettings.setDataTable(dataTable);
        }
        dataTable.addDataTableListener(this);
        this.dataTableUpdated(dataTable);
    }

    @Override
    public void dataTableUpdated(DataTable dataTable) {
        this.generalInfo.setText(dataTable.getName() + " (" + dataTable.getNumberOfRows() + " rows, " + dataTable.getNumberOfColumns() + " columns)");
    }

    @Override
    public void prepareReporting() {
        this.dataTableViewerTable.prepareReporting();
    }

    @Override
    public void finishReporting() {
        this.dataTableViewerTable.finishReporting();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.dataTableViewerTable.getColumnName(columnIndex);
    }

    @Override
    public String getCell(int row, int column) {
        return this.dataTableViewerTable.getCell(row, column);
    }

    @Override
    public int getColumnNumber() {
        return this.dataTableViewerTable.getColumnNumber();
    }

    @Override
    public int getRowNumber() {
        return this.dataTableViewerTable.getRowNumber();
    }

    @Override
    public boolean isFirstLineHeader() {
        return false;
    }

    @Override
    public boolean isFirstColumnHeader() {
        return false;
    }
}

