/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.viewer.DataTableViewerTableModel;
import java.util.List;

public class DataTableColumnEditTableModel
extends DataTableViewerTableModel {
    private static final long serialVersionUID = 8116530590493627673L;
    private transient DataTable dataTable;
    private List<String> editableColumnNames;
    private Object[][] editableColumnValues;

    public DataTableColumnEditTableModel(DataTable dataTable, List<String> editableColumnNames) {
        super(dataTable);
        this.dataTable = dataTable;
        this.editableColumnNames = editableColumnNames;
        this.editableColumnValues = new Object[editableColumnNames.size()][dataTable.getNumberOfRows()];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex < this.editableColumnNames.size();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column < this.editableColumnNames.size()) {
            return Object.class;
        }
        return super.getColumnClass(column - this.editableColumnNames.size());
    }

    @Override
    public int getRowCount() {
        return this.dataTable.getNumberOfRows();
    }

    @Override
    public int getColumnCount() {
        return this.dataTable.getNumberOfColumns() + this.editableColumnNames.size();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex < this.editableColumnNames.size()) {
            this.editableColumnValues[columnIndex][rowIndex] = aValue;
        }
        super.setValueAt(aValue, rowIndex, columnIndex - this.editableColumnNames.size());
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col < this.editableColumnNames.size()) {
            return this.editableColumnValues[col][row];
        }
        return super.getValueAt(row, col - this.editableColumnNames.size());
    }

    @Override
    public String getColumnName(int col) {
        if (col < this.editableColumnNames.size()) {
            return this.editableColumnNames.get(col);
        }
        return super.getColumnName(col - this.editableColumnNames.size());
    }

    public Object[] getEnteredValues(int column) {
        return this.editableColumnValues[column];
    }
}

