/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableListener;
import com.rapidminer.gui.tools.CellColorProvider;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.viewer.DataTableColumnEditTableModel;
import com.rapidminer.tools.container.Pair;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jfree.ui.DateCellRenderer;

public class DataTableColumnEditTable
extends ExtendedJTable
implements DataTableListener {
    private static final long serialVersionUID = 3206734427933036268L;
    private DataTableColumnEditTableModel model;
    private List<String> editableColumnNames;
    private List<Pair<TableCellRenderer, TableCellEditor>> cellComponents;

    public DataTableColumnEditTable(DataTable dataTable, List<String> editableColumnNames, List<Pair<TableCellRenderer, TableCellEditor>> cellComponents, boolean sortable, boolean columnMovable, boolean autoResize) {
        super(sortable, columnMovable, autoResize);
        this.editableColumnNames = editableColumnNames;
        this.cellComponents = cellComponents;
        if (this.model != null) {
            this.setDataTable(dataTable);
        }
    }

    public void setDataTable(DataTable dataTable) {
        this.model = new DataTableColumnEditTableModel(dataTable, this.editableColumnNames);
        this.setModel(this.model);
        int i = 0;
        for (Pair<TableCellRenderer, TableCellEditor> cellComponent : this.cellComponents) {
            TableColumn column = this.getColumnModel().getColumn(i);
            column.setCellEditor(cellComponent.getSecond());
            column.setCellRenderer(cellComponent.getFirst());
            ++i;
        }
        while (i < this.model.getColumnCount()) {
            TableColumn column = this.getColumnModel().getColumn(i);
            column.setCellEditor(new DefaultCellEditor(new JTextField()));
            column.setCellRenderer((TableCellRenderer)new DateCellRenderer());
            ++i;
        }
        this.setCellColorProvider(new CellColorProvider(){

            @Override
            public Color getCellColor(int row, int col) {
                if (row % 2 == 0) {
                    return Color.WHITE;
                }
                return SwingTools.LIGHTEST_BLUE;
            }
        });
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        return super.getCellEditor(row, column);
    }

    public Object[] getEnteredValues(int column) {
        return this.model.getEnteredValues(column);
    }

    @Override
    public void dataTableUpdated(DataTable source) {
        if (this.model != null) {
            this.model.fireTableDataChanged();
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realColumnIndex = DataTableColumnEditTable.this.convertColumnIndexToModel(index);
                if (realColumnIndex >= 0 && realColumnIndex < DataTableColumnEditTable.this.getModel().getColumnCount()) {
                    return "The column " + DataTableColumnEditTable.this.getModel().getColumnName(realColumnIndex);
                }
                return "";
            }
        };
    }
}

