/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.tools.Tools;
import javax.swing.table.AbstractTableModel;

public class ConfusionMatrixViewerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1206988933244249851L;
    private String[] classNames;
    private double[][] counter;
    private double[] rowSums;
    private double[] columnSums;

    public ConfusionMatrixViewerTableModel(String[] classNames, double[][] counter) {
        this.classNames = classNames;
        this.counter = counter;
        this.rowSums = new double[classNames.length];
        this.columnSums = new double[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            for (int j = 0; j < classNames.length; ++j) {
                int n = i;
                this.columnSums[n] = this.columnSums[n] + counter[i][j];
                int n2 = i;
                this.rowSums[n2] = this.rowSums[n2] + counter[j][i];
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.classNames.length + 2;
    }

    @Override
    public int getColumnCount() {
        return this.classNames.length + 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row == 0) {
            if (col == 0) {
                return "";
            }
            if (col == this.getColumnCount() - 1) {
                return "class precision";
            }
            return "true " + this.classNames[col - 1];
        }
        if (row == this.getRowCount() - 1) {
            if (col == 0) {
                return "class recall";
            }
            if (col == this.getColumnCount() - 1) {
                return "";
            }
            double recall = this.counter[col - 1][col - 1] / this.columnSums[col - 1];
            if (Double.isNaN(recall)) {
                return Tools.formatPercent(0.0);
            }
            return Tools.formatPercent(recall);
        }
        if (col == 0) {
            if (row - 1 >= 0) {
                return "pred. " + this.classNames[row - 1];
            }
            return "";
        }
        if (col == this.getColumnCount() - 1) {
            double precision = this.counter[row - 1][row - 1] / this.rowSums[row - 1];
            if (Double.isNaN(precision)) {
                return Tools.formatPercent(0.0);
            }
            return Tools.formatPercent(precision);
        }
        if (col - 1 >= 0 && row - 1 >= 0) {
            return Tools.formatIntegerIfPossible(this.counter[col - 1][row - 1]);
        }
        return "";
    }
}

