/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.viewer.ConfusionMatrixViewerTable;
import com.rapidminer.report.Tableable;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;

public class ConfusionMatrixViewer
extends JPanel
implements Tableable {
    private static final long serialVersionUID = 3448880915145528006L;
    private ConfusionMatrixViewerTable table;

    public ConfusionMatrixViewer(String performance, String[] classNames, double[][] counter) {
        this.setLayout(new BorderLayout());
        final JPanel mainPanel = new JPanel();
        final CardLayout cardLayout = new CardLayout();
        mainPanel.setLayout(cardLayout);
        this.add((Component)mainPanel, "Center");
        JPanel tablePanel = new JPanel(new BorderLayout());
        JPanel infoPanel = new JPanel(new FlowLayout(0));
        JTextPane infoText = new JTextPane();
        infoText.setEditable(false);
        infoText.setBackground(infoPanel.getBackground());
        infoText.setFont(infoText.getFont().deriveFont(1));
        infoText.setText(performance);
        infoPanel.add(infoText);
        infoPanel.setBorder(BorderFactory.createEtchedBorder());
        tablePanel.add((Component)infoPanel, "North");
        this.table = new ConfusionMatrixViewerTable(classNames, counter);
        this.table.setBorder(BorderFactory.createEtchedBorder());
        tablePanel.add((Component)this.table, "Center");
        SimpleDataTable dataTable = new SimpleDataTable("Confusion Matrix", new String[]{"True Class", "Predicted Class", "Confusion Matrix (x: true class,  y: pred. class,  z: counters)"});
        for (int row = 0; row < classNames.length; ++row) {
            for (int column = 0; column < classNames.length; ++column) {
                dataTable.add(new SimpleDataTableRow(new double[]{row, column, counter[row][column]}));
            }
        }
        PlotterConfigurationModel settings = new PlotterConfigurationModel("Sticks 3D", (DataTable)dataTable);
        settings.setAxis(0, 0);
        settings.setAxis(1, 1);
        settings.enablePlotColumn(2);
        mainPanel.add((Component)tablePanel, "table");
        mainPanel.add((Component)settings.getPlotter().getPlotter(), "plot");
        final JRadioButton metaDataButton = new JRadioButton("Table View", true);
        metaDataButton.setToolTipText("Changes to a table showing the confusion matrix.");
        metaDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (metaDataButton.isSelected()) {
                    cardLayout.show(mainPanel, "table");
                }
            }
        });
        final JRadioButton plotButton = new JRadioButton("Plot View", false);
        plotButton.setToolTipText("Changes to a plot view of the confusion matrix.");
        plotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (plotButton.isSelected()) {
                    cardLayout.show(mainPanel, "plot");
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(metaDataButton);
        group.add(plotButton);
        JPanel togglePanel = new JPanel(new FlowLayout(0));
        togglePanel.add(metaDataButton);
        togglePanel.add(plotButton);
        this.add((Component)togglePanel, "North");
    }

    @Override
    public void prepareReporting() {
        this.table.prepareReporting();
    }

    @Override
    public void finishReporting() {
        this.table.finishReporting();
    }

    @Override
    public boolean isFirstLineHeader() {
        return true;
    }

    @Override
    public boolean isFirstColumnHeader() {
        return true;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.table.getColumnName(columnIndex);
    }

    @Override
    public String getCell(int row, int column) {
        return this.table.getCell(row, column);
    }

    @Override
    public int getColumnNumber() {
        return this.table.getColumnNumber();
    }

    @Override
    public int getRowNumber() {
        return this.table.getRowNumber();
    }
}

