/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.ObjectVisualizer;
import com.rapidminer.operator.clustering.Cluster;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterNode;
import com.rapidminer.report.Renderable;
import com.rapidminer.tools.ObjectVisualizerService;
import java.awt.Graphics;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class ClusterTreeVisualization
extends JTree
implements TreeSelectionListener,
Renderable {
    private static final long serialVersionUID = 3994390578811027103L;
    private Object clusterModel;

    public ClusterTreeVisualization(HierarchicalClusterModel cm) {
        DefaultTreeModel model = new DefaultTreeModel(this.generateTreeModel(cm.getRootNode()));
        this.setModel(model);
        this.addTreeSelectionListener(this);
        this.clusterModel = cm;
    }

    public ClusterTreeVisualization(ClusterModel cm) {
        DefaultTreeModel model = new DefaultTreeModel(this.generateFlatModel(cm));
        this.setModel(model);
        this.addTreeSelectionListener(this);
        this.clusterModel = cm;
    }

    private DefaultMutableTreeNode generateFlatModel(ClusterModel cm) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("root");
        rootNode.setAllowsChildren(true);
        for (int i = 0; i < cm.getNumberOfClusters(); ++i) {
            Cluster cl = cm.getCluster(i);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(cl);
            newNode.setAllowsChildren(true);
            rootNode.add(newNode);
            for (Object exampleId : cl.getExampleIds()) {
                if (exampleId instanceof String) {
                    newNode.add(this.createLeaf(exampleId));
                    continue;
                }
                newNode.add(this.createLeaf(exampleId));
            }
        }
        return rootNode;
    }

    private DefaultMutableTreeNode generateTreeModel(HierarchicalClusterNode cl) {
        DefaultMutableTreeNode result = new DefaultMutableTreeNode(cl);
        result.setAllowsChildren(true);
        for (HierarchicalClusterNode subNode : cl.getSubNodes()) {
            result.add(this.generateTreeModel(subNode));
        }
        for (Object exampleId : cl.getExampleIdsInSubtree()) {
            result.add(this.createLeaf(exampleId));
        }
        return result;
    }

    private MutableTreeNode createLeaf(Object id) {
        ObjectVisualizer viz = ObjectVisualizerService.getVisualizerForObject(this.clusterModel);
        String title = viz.getTitle(id);
        if (title == null) {
            title = id instanceof String ? (String)id : ((Integer)id).toString();
        }
        DefaultMutableTreeNode newLeaf = new DefaultMutableTreeNode(new ClusterTreeLeaf(title, id));
        newLeaf.setAllowsChildren(false);
        return newLeaf;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node;
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return;
        }
        if (paths.length == 1 && !(node = (DefaultMutableTreeNode)paths[0].getLastPathComponent()).getAllowsChildren()) {
            ClusterTreeLeaf leaf = (ClusterTreeLeaf)node.getUserObject();
            ObjectVisualizer viz = ObjectVisualizerService.getVisualizerForObject(this.clusterModel);
            viz.startVisualization(leaf.getId());
        }
    }

    public void expandAll() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            this.expandRow(row);
        }
    }

    @Override
    public void prepareRendering() {
        this.expandAll();
    }

    @Override
    public void finishRendering() {
    }

    @Override
    public int getRenderHeight(int preferredHeight) {
        return Math.max(this.getPreferredSize().height, preferredHeight);
    }

    @Override
    public int getRenderWidth(int preferredWidth) {
        return Math.max(this.getPreferredSize().width, preferredWidth);
    }

    @Override
    public void render(Graphics graphics, int width, int height) {
        this.setSize(width, height);
        this.paint(graphics);
    }

    private static class ClusterTreeLeaf {
        private final String title;
        private final Object id;

        public ClusterTreeLeaf(String title, Object id) {
            this.title = title;
            this.id = id;
        }

        public String toString() {
            return this.title;
        }

        public Object getId() {
            return this.id;
        }
    }
}

