/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.gui.processeditor.results.ResultDisplayTools;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.report.Readable;
import com.rapidminer.tools.math.Averagable;
import com.rapidminer.tools.math.AverageVector;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AverageVectorViewer
extends JPanel
implements Readable {
    private static final long serialVersionUID = -5108739438512582933L;
    private AverageVector vector;

    public AverageVectorViewer(AverageVector vector, IOContainer container) {
        this.setLayout(new GridLayout(1, 1));
        this.vector = vector;
        JPanel mainPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        mainPanel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(11, 11, 11, 11);
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JLabel mainLabel = new JLabel("<html><h2>" + this.getName() + " (" + vector.size() + ")</h2></html>");
        layout.setConstraints(mainLabel, c);
        mainPanel.add(mainLabel);
        for (int i = 0; i < vector.size(); ++i) {
            Averagable avg = vector.getAveragable(i);
            JPanel visualizationComponent = ResultDisplayTools.createVisualizationComponent(avg, container, "Averagable");
            layout.setConstraints(visualizationComponent, c);
            mainPanel.add(visualizationComponent);
        }
        this.add(new ExtendedJScrollPane(mainPanel));
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.vector.size(); ++i) {
            buffer.append(this.vector.getAveragable(i).toString());
        }
        return buffer.toString();
    }

    @Override
    public boolean isInTargetEncoding() {
        return false;
    }
}

