/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.operator.visualization.dependencies.ANOVAMatrix;
import com.rapidminer.tools.Tools;
import javax.swing.table.AbstractTableModel;

public class ANOVAMatrixViewerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -5732155307505605893L;
    private ANOVAMatrix matrix;

    public ANOVAMatrixViewerTableModel(ANOVAMatrix matrix) {
        this.matrix = matrix;
    }

    @Override
    public int getRowCount() {
        return this.matrix.getAnovaAttributeNames().size();
    }

    @Override
    public int getColumnCount() {
        return this.matrix.getGroupingAttributeNames().size() + 1;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "ANOVA Attribute";
        }
        return "group " + this.matrix.getGroupingAttributeNames().get(col - 1);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.matrix.getAnovaAttributeNames().get(row);
        }
        return Tools.formatNumber(this.matrix.getProbabilities()[row][col - 1]);
    }
}

