/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.table;

import com.rapidminer.gui.tools.table.EditableTableHeaderColumn;
import com.rapidminer.gui.tools.table.EditableTableHeaderUI;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class EditableTableHeader
extends JTableHeader
implements CellEditorListener {
    private static final long serialVersionUID = 1L;
    public final int HEADER_ROW = -10;
    protected transient int editingColumn;
    protected transient TableCellEditor cellEditor;
    protected transient Component editorComp;

    public EditableTableHeader(TableColumnModel columnModel) {
        super(columnModel);
        this.setReorderingAllowed(false);
        this.cellEditor = null;
        this.recreateTableColumn(columnModel);
    }

    @Override
    public void updateUI() {
        this.setUI(new EditableTableHeaderUI());
        this.resizeAndRepaint();
        this.invalidate();
    }

    protected void recreateTableColumn(TableColumnModel columnModel) {
        int i;
        int n = columnModel.getColumnCount();
        EditableTableHeaderColumn[] newCols = new EditableTableHeaderColumn[n];
        TableColumn[] oldCols = new TableColumn[n];
        for (i = 0; i < n; ++i) {
            oldCols[i] = columnModel.getColumn(i);
            newCols[i] = new EditableTableHeaderColumn();
            newCols[i].copyValues(oldCols[i]);
        }
        for (i = 0; i < n; ++i) {
            columnModel.removeColumn(oldCols[i]);
        }
        for (i = 0; i < n; ++i) {
            columnModel.addColumn(newCols[i]);
        }
    }

    public boolean editCellAt(int index, EventObject e) {
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (!this.isCellEditable(index)) {
            return false;
        }
        TableCellEditor editor = this.getCellEditor(index);
        if (editor != null && editor.isCellEditable(e)) {
            this.editorComp = this.prepareEditor(editor, index);
            this.editorComp.setBounds(this.getHeaderRect(index));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.setCellEditor(editor);
            this.setEditingColumn(index);
            editor.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    public boolean isCellEditable(int index) {
        if (this.getReorderingAllowed()) {
            return false;
        }
        int columnIndex = this.columnModel.getColumn(index).getModelIndex();
        EditableTableHeaderColumn col = (EditableTableHeaderColumn)this.columnModel.getColumn(columnIndex);
        return col.isHeaderEditable();
    }

    public TableCellEditor getCellEditor(int index) {
        int columnIndex = this.columnModel.getColumn(index).getModelIndex();
        EditableTableHeaderColumn col = (EditableTableHeaderColumn)this.columnModel.getColumn(columnIndex);
        return col.getHeaderEditor();
    }

    public void setCellEditor(TableCellEditor newEditor) {
        TableCellEditor oldEditor = this.cellEditor;
        this.cellEditor = newEditor;
        if (oldEditor != null && oldEditor instanceof TableCellEditor) {
            oldEditor.removeCellEditorListener(this);
        }
        if (newEditor != null) {
            newEditor.addCellEditorListener(this);
        }
    }

    public Component prepareEditor(TableCellEditor editor, int index) {
        Object value = this.columnModel.getColumn(index).getHeaderValue();
        boolean isSelected = true;
        int row = -10;
        JTable table = this.getTable();
        Component comp = editor.getTableCellEditorComponent(table, value, isSelected, row, index);
        if (comp instanceof JComponent) {
            ((JComponent)comp).setNextFocusableComponent(this);
        }
        return comp;
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public void setEditingColumn(int aColumn) {
        this.editingColumn = aColumn;
    }

    public int getEditingColumn() {
        return this.editingColumn;
    }

    public void removeEditor() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.removeCellEditorListener(this);
            this.requestFocus();
            this.remove(this.editorComp);
            int index = this.getEditingColumn();
            Rectangle cellRect = this.getHeaderRect(index);
            this.setCellEditor(null);
            this.setEditingColumn(-1);
            this.editorComp = null;
            this.repaint(cellRect);
        }
    }

    public boolean isEditing() {
        return this.cellEditor != null;
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            Object value = editor.getCellEditorValue();
            int index = this.getEditingColumn();
            this.columnModel.getColumn(index).setHeaderValue(value);
            this.removeEditor();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.removeEditor();
    }
}

