/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport.excel;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTabbedPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.excel.AnnotationCellEditor;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.ExcelExampleSource;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class ExcelWorkbookPane
extends JPanel {
    private static final long serialVersionUID = 9179757216097316344L;
    private Workbook excelWorkbook;
    private ExtendedJTabbedPane sheetsPane;
    private ExtendedJTable[] tables;
    private ExcelWorkbookSelection selectedView;
    private WizardStep wizardStep;
    private ExcelExampleSource reader;

    public ExcelWorkbookPane(WizardStep wizardStep, ExcelExampleSource reader) {
        this.wizardStep = wizardStep;
        this.reader = reader;
        this.sheetsPane = new ExtendedJTabbedPane();
        this.sheetsPane.setBorder(null);
        this.setLayout(new BorderLayout());
        this.add(this.sheetsPane);
    }

    public ExcelWorkbookSelection getSelection() {
        if (this.selectedView == null) {
            int sheetIndex = this.sheetsPane.getSelectedIndex();
            int columnIndexStart = this.tables[sheetIndex].getSelectedColumn();
            int rowIndexStart = this.tables[sheetIndex].getSelectedRow();
            int columnIndexEnd = columnIndexStart + this.tables[sheetIndex].getSelectedColumnCount() - 1;
            int rowIndexEnd = rowIndexStart + this.tables[sheetIndex].getSelectedRowCount() - 1;
            if (columnIndexStart == -1) {
                return new ExcelWorkbookSelection(sheetIndex, 0, 0, this.tables[sheetIndex].getColumnCount() - 1, this.tables[sheetIndex].getRowCount() - 1);
            }
            return new ExcelWorkbookSelection(sheetIndex, columnIndexStart, rowIndexStart, columnIndexEnd, rowIndexEnd);
        }
        int sheetIndex = this.selectedView.getSheetIndex();
        int columnIndexStart = this.tables[0].getSelectedColumn() + this.selectedView.getColumnIndexStart();
        int rowIndexStart = this.tables[0].getSelectedRow() + this.selectedView.getRowIndexStart();
        int columnIndexEnd = columnIndexStart + this.tables[0].getSelectedColumnCount() - 1 + this.selectedView.getColumnIndexStart();
        int rowIndexEnd = rowIndexStart + this.tables[0].getSelectedRowCount() - 1 + this.selectedView.getRowIndexStart();
        if (columnIndexStart == -1) {
            return new ExcelWorkbookSelection(sheetIndex, this.selectedView.getColumnIndexStart(), this.selectedView.getRowIndexStart(), this.selectedView.getColumnIndexEnd(), this.selectedView.getRowIndexEnd());
        }
        return new ExcelWorkbookSelection(sheetIndex, columnIndexStart, rowIndexStart, columnIndexEnd, rowIndexEnd);
    }

    public void loadWorkbook() {
        File file = null;
        try {
            file = this.reader.getParameterAsFile("excel_file");
        }
        catch (UndefinedParameterError e1) {
            throw new RuntimeException("Error during loading workbook: ", e1);
        }
        try {
            this.excelWorkbook = Workbook.getWorkbook((File)file);
        }
        catch (BiffException e1) {
            LogService.getRoot().log(Level.WARNING, "Error loading workbook: " + (Object)((Object)e1), e1);
            return;
        }
        catch (IOException e1) {
            LogService.getRoot().log(Level.WARNING, "Error loading workbook: " + e1, e1);
            return;
        }
        this.sheetsPane.removeAll();
        JPanel dummy = new JPanel();
        dummy.add(new JLabel("Loading Excel Sheets"));
        this.sheetsPane.addTab("  ", dummy);
        this.tables = new ExtendedJTable[this.excelWorkbook.getNumberOfSheets()];
        new ProgressThread("load_workbook"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String[] sheetNames = ExcelWorkbookPane.this.excelWorkbook.getSheetNames();
                for (int sheetIndex = 0; sheetIndex < ExcelWorkbookPane.this.excelWorkbook.getNumberOfSheets(); ++sheetIndex) {
                    ExcelExampleSource excelExampleSource = ExcelWorkbookPane.this.reader;
                    synchronized (excelExampleSource) {
                        ExcelWorkbookPane.this.reader.setParameter("sheet_number", Integer.toString(sheetIndex + 1));
                        ExcelWorkbookPane.this.reader.clearReaderSettings();
                        LinkedList<Object[]> data = null;
                        try {
                            data = ExcelWorkbookPane.this.reader.getShortPreviewAsList(this.getProgressListener(), true);
                        }
                        catch (OperatorException e1) {
                            data = new LinkedList<Object[]>();
                            data.add(new Object[0]);
                        }
                        ExcelSheetModel sheetModel = new ExcelSheetModel(ExcelWorkbookPane.this, data);
                        sheetModel.addTableModelListener(new TableModelListener(){

                            @Override
                            public void tableChanged(TableModelEvent e) {
                                if (ExcelWorkbookPane.this.wizardStep != null) {
                                    ExcelWorkbookPane.this.wizardStep.fireStateChanged();
                                }
                            }
                        });
                        ((ExcelWorkbookPane)ExcelWorkbookPane.this).tables[sheetIndex] = new ExtendedJTable(sheetModel, false, false){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public TableCellRenderer getCellRenderer(int row, int col) {
                                if (col > 0) {
                                    return super.getCellRenderer(row, col);
                                }
                                return new DefaultTableCellRenderer(){
                                    private static final long serialVersionUID = 2791054497317720420L;

                                    @Override
                                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                                        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                                        component.setBackground(ExcelWorkbookPane.this.getBackground());
                                        component.setForeground(Color.BLACK);
                                        return component;
                                    }
                                };
                            }
                        };
                        ExcelWorkbookPane.this.tables[sheetIndex].setAutoResizeMode(0);
                        ExcelWorkbookPane.this.tables[sheetIndex].setBorder(null);
                        ExcelWorkbookPane.this.tables[sheetIndex].getColumnModel().getColumn(0).setCellEditor(new AnnotationCellEditor(ExcelWorkbookPane.this.getBackground()));
                        ExcelWorkbookPane.this.tables[sheetIndex].setRowSelectionAllowed(false);
                        ExcelWorkbookPane.this.tables[sheetIndex].setColumnSelectionAllowed(false);
                        ExcelWorkbookPane.this.tables[sheetIndex].setCellSelectionEnabled(false);
                        ExtendedJScrollPane pane = new ExtendedJScrollPane(ExcelWorkbookPane.this.tables[sheetIndex]);
                        pane.setBorder(null);
                        if (sheetIndex == 0) {
                            ExcelWorkbookPane.this.sheetsPane.removeAll();
                        }
                        ExcelWorkbookPane.this.sheetsPane.addTab(sheetNames[sheetIndex], pane);
                        continue;
                    }
                }
            }
        }.start();
    }

    public String getColumnName(int sheet, int index) {
        return this.tables[sheet].getColumnName(index);
    }

    private class ExcelSheetModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final Map<Integer, String> annotationTypes;
        private ArrayList<Object[]> data;
        final /* synthetic */ ExcelWorkbookPane this$0;

        /*
         * Exception decompiling
         */
        public ExcelSheetModel(ExcelWorkbookPane var1_1, List<Object[]> data) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if ("-".equals(aValue)) {
                    this.getAnnotationMap().remove(rowIndex);
                } else {
                    this.getAnnotationMap().put(rowIndex, (String)aValue);
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                String value = this.getAnnotationMap().get(rowIndex);
                if (value == null) {
                    return "-";
                }
                return value;
            }
            --columnIndex;
            if (rowIndex >= this.data.size()) {
                return "";
            }
            if (columnIndex >= this.data.get(rowIndex).length) {
                return "";
            }
            return this.data.get(rowIndex)[columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Use as";
            }
            if (columnIndex == 1) {
                return "Row No.";
            }
            return Tools.getExcelColumnName(columnIndex - 2);
        }

        @Override
        public int getColumnCount() {
            if (this.data.isEmpty()) {
                return 1;
            }
            return this.data.get(0).length + 1;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Map<Integer, String> getAnnotationMap() {
            return this.annotationTypes;
        }
    }

    public class ExcelWorkbookSelection {
        private int sheetIndex;
        private int columnIndexStart;
        private int rowIndexStart;
        private int columnIndexEnd;
        private int rowIndexEnd;

        public ExcelWorkbookSelection(int sheetIndex, int columnIndexStart, int rowIndexStart, int columnIndexEnd, int rowIndexEnd) {
            this.sheetIndex = sheetIndex;
            this.columnIndexStart = columnIndexStart;
            this.rowIndexStart = rowIndexStart;
            this.columnIndexEnd = columnIndexEnd;
            this.rowIndexEnd = rowIndexEnd;
        }

        public String toString() {
            return this.sheetIndex + ": " + this.columnIndexStart + ":" + this.rowIndexStart + " - " + this.columnIndexEnd + ":" + this.rowIndexEnd;
        }

        public int getSheetIndex() {
            return this.sheetIndex;
        }

        public int getColumnIndexEnd() {
            return this.columnIndexEnd;
        }

        public int getColumnIndexStart() {
            return this.columnIndexStart;
        }

        public int getRowIndexEnd() {
            return this.rowIndexEnd;
        }

        public int getRowIndexStart() {
            return this.rowIndexStart;
        }

        public int getSelectionWidth() {
            return this.columnIndexEnd - this.columnIndexStart + 1;
        }

        public int getSelectionHeight() {
            return this.rowIndexEnd - this.rowIndexStart + 1;
        }

        public Map<Integer, String> getAnnotationMap() {
            return ((ExcelSheetModel)ExcelWorkbookPane.this.tables[this.sheetIndex].getModel()).getAnnotationMap();
        }
    }
}

