/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport.excel;

import com.rapidminer.gui.tools.SimpleFileFilter;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.DataImportWizard;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.FileSelectionWizardStep;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.MetaDataDeclerationWizardStep;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.RepositoryLocationSelectionWizardStep;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.excel.ExcelWorkbookPane;
import com.rapidminer.gui.wizards.AbstractConfigurationWizardCreator;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.io.ExcelExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.OperatorService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class ExcelImportWizard
extends DataImportWizard {
    private static final long serialVersionUID = -4308448171060612833L;
    private File file = null;
    private ExcelExampleSource reader = null;
    private Parameters parametersBackup;
    private final WizardStep STEP_FILE_SELECTION = new FileSelectionWizardStep(this, new FileFilter[]{new SimpleFileFilter("Excel File (.xls)", ".xls")}){

        @Override
        protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
            if (ExcelImportWizard.this.file != null && ExcelImportWizard.this.file.exists()) {
                this.fileChooser.setSelectedFile(ExcelImportWizard.this.file);
            }
            return true;
        }

        @Override
        protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
            ExcelImportWizard.this.reader.setParameter("annotations", null);
            ExcelImportWizard.this.file = this.getSelectedFile();
            File oldFile = null;
            try {
                oldFile = ExcelImportWizard.this.reader.getParameterAsFile("excel_file");
            }
            catch (UndefinedParameterError e) {
                oldFile = null;
            }
            if (oldFile == null || !oldFile.equals(ExcelImportWizard.this.file)) {
                ExcelImportWizard.this.reader.clearAllReaderSettings();
            }
            ExcelImportWizard.this.reader.setParameter("excel_file", ExcelImportWizard.this.file.getAbsolutePath());
            return true;
        }
    };

    @Override
    public void cancel() {
        this.reader.getParameters().setAll(this.parametersBackup);
        this.reader.stopReading();
        super.cancel();
    }

    @Override
    public void finish() {
        this.reader.stopReading();
        super.finish();
    }

    public ExcelImportWizard(String i18nKey, ConfigurationListener listener, File preselectedFile, boolean showStoreInRepositoryStep, RepositoryLocation preselectedLocation, Object ... i18nArgs) {
        super(i18nKey, i18nArgs);
        this.file = preselectedFile;
        if (listener != null) {
            this.reader = (ExcelExampleSource)listener;
        } else {
            try {
                this.reader = OperatorService.createOperator(ExcelExampleSource.class);
            }
            catch (OperatorCreationException e) {
                throw new RuntimeException("Failed to create excel reader: " + e, e);
            }
        }
        this.parametersBackup = (Parameters)this.reader.getParameters().clone();
        this.addStep(this.STEP_FILE_SELECTION);
        this.addStep(new ExcelWorkSheetSelection(this.reader));
        this.addStep(new MetaDataDeclerationWizardStep("select_attributes", this.reader){

            @Override
            protected JComponent getComponent() {
                JPanel typeDetection = new JPanel(ButtonDialog.createGridLayout(1, 2));
                typeDetection.setBorder(ButtonDialog.createTitledBorder("Value Type Detection"));
                typeDetection.add(new JLabel("Guess the value types of all attributes"));
                typeDetection.add(this.guessingButtonsPanel);
                Component[] superComponents = super.getComponent().getComponents();
                JPanel upperPanel = new JPanel(new BorderLayout());
                upperPanel.add((Component)typeDetection, "North");
                upperPanel.add(superComponents[0], "Center");
                JPanel panel = new JPanel(new BorderLayout(0, 6));
                panel.add((Component)upperPanel, "North");
                panel.add(superComponents[1], "Center");
                return panel;
            }

            @Override
            protected void doAfterEnteringAction() {
                this.reader.setAttributeNamesDefinedByUser(true);
                ((ExcelExampleSource)this.reader).skipNameAnnotationRow(true);
            }

            @Override
            protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                this.reader.stopReading();
                this.reader.writeMetaDataInParameter();
                return true;
            }
        });
        if (showStoreInRepositoryStep) {
            this.addStep(new RepositoryLocationSelectionWizardStep(this, preselectedLocation != null ? preselectedLocation.getAbsoluteLocation() : null){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                    ExcelExampleSource excelExampleSource = ExcelImportWizard.this.reader;
                    synchronized (excelExampleSource) {
                        boolean flag = ExcelImportWizard.this.transferData(ExcelImportWizard.this.reader, this.getRepositoryLocation());
                        return flag;
                    }
                }
            });
        }
        this.layoutDefault(9);
    }

    public ExcelImportWizard(String i18nKey, Object ... i18nArgs) {
        this(i18nKey, (ConfigurationListener)null, (File)null, true, null, i18nArgs);
    }

    public ExcelImportWizard(String i18nKey, File preselectedFile, RepositoryLocation preselectedLocation, Object ... i18nArgs) {
        this(i18nKey, preselectedFile, true, preselectedLocation, i18nArgs);
    }

    public ExcelImportWizard(String i18nKey, File preselectedFile, ConfigurationListener listener, Object ... i18nArgs) {
        this(i18nKey, preselectedFile, false, null, i18nArgs);
    }

    public ExcelImportWizard(String i18nKey, ExcelExampleSource reader, Object ... i18nArgs) {
        super(i18nKey, i18nArgs);
        this.reader = reader;
        this.addStep(this.STEP_FILE_SELECTION);
        this.addStep(new ExcelWorkSheetSelection(reader));
        this.layoutDefault(3);
    }

    public static class ExcelExampleSourceConfigurationWizardCreator
    extends AbstractConfigurationWizardCreator {
        private static final long serialVersionUID = 1L;

        @Override
        public void createConfigurationWizard(ParameterType type, ConfigurationListener listener) {
            String fileLocation = "";
            try {
                fileLocation = listener.getParameters().getParameter("excel_file");
                if (fileLocation == null) {
                    throw new UndefinedParameterError("");
                }
                File file = new File(fileLocation);
                new ExcelImportWizard(this.getI18NKey(), listener, file, false, null, new Object[0]).setVisible(true);
            }
            catch (UndefinedParameterError e) {
                new ExcelImportWizard(this.getI18NKey(), listener, null, false, null, new Object[0]).setVisible(true);
            }
        }

        @Override
        public String getI18NKey() {
            return "data_import_wizard";
        }
    }

    private static class ExcelWorkSheetSelection
    extends WizardStep {
        private final ExcelWorkbookPane workbookSelectionPanel;
        private final JLabel errorLabel = new JLabel("");
        ExcelExampleSource reader;

        public ExcelWorkSheetSelection(ExcelExampleSource reader) {
            super("excel_data_selection");
            this.reader = reader;
            this.workbookSelectionPanel = new ExcelWorkbookPane(this, reader);
        }

        @Override
        protected boolean canGoBack() {
            return true;
        }

        @Override
        protected boolean canProceed() {
            return true;
        }

        @Override
        protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
            this.reader.stopReading();
            this.reader.setParameter("first_row_as_names", Boolean.FALSE.toString());
            this.reader.skipNameAnnotationRow(false);
            boolean flag = this.reader.attributeNamesDefinedByUser();
            this.workbookSelectionPanel.loadWorkbook();
            this.reader.setAttributeNamesDefinedByUser(flag);
            return true;
        }

        @Override
        protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
            if (this.reader.attributeNamesDefinedByUser()) {
                this.reader.loadMetaDataFromParameters();
            }
            this.reader.stopReading();
            this.reader.setParameter("sheet_number", Integer.toString(this.workbookSelectionPanel.getSelection().getSheetIndex() + 1));
            LinkedList<String[]> annotationParameter = new LinkedList<String[]>();
            boolean nameAnnotationFound = false;
            for (Map.Entry<Integer, String> entry : this.workbookSelectionPanel.getSelection().getAnnotationMap().entrySet()) {
                annotationParameter.add(new String[]{entry.getKey().toString(), entry.getValue()});
                if (!entry.getValue().equals("Name")) continue;
                nameAnnotationFound = true;
            }
            this.reader.setParameter("annotations", ParameterTypeList.transformList2String(annotationParameter));
            if (nameAnnotationFound) {
                this.reader.setAttributeNamesDefinedByUser(false);
                this.reader.skipNameAnnotationRow(false);
            } else {
                this.reader.skipNameAnnotationRow(true);
            }
            return true;
        }

        @Override
        protected JComponent getComponent() {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.workbookSelectionPanel, "Center");
            panel.add((Component)this.errorLabel, "South");
            return panel;
        }
    }
}

