/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport.csv;

import com.rapidminer.gui.tools.CharTextField;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.MetaDataDeclerationWizardStep;
import com.rapidminer.operator.io.AbstractDataReader;
import com.rapidminer.parameter.UndefinedParameterError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class ParseValueTypesWizardStep
extends MetaDataDeclerationWizardStep {
    private final KeyAdapter textFieldKeyListener = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            ParseValueTypesWizardStep.this.settingsChanged();
        }
    };
    private final CharTextField decimalPointCharacterTextField = new CharTextField('.');
    private final CharTextField groupingCharacterTextField;
    private final JCheckBox groupNumbersBox;
    private final JTextField dateFormatTextField;

    protected void settingsChanged() {
        this.reader.setParameter("date_format", this.getDateFormat());
        this.reader.setParameter("decimal_character", Character.toString(this.getDecimalPointCharacter()));
        this.reader.setParameter("grouping_character", Character.toString(this.getGroupingSeparator()));
    }

    public ParseValueTypesWizardStep(String key, AbstractDataReader reader) {
        super(key, reader);
        this.decimalPointCharacterTextField.addKeyListener(this.textFieldKeyListener);
        this.groupingCharacterTextField = new CharTextField(',');
        this.groupingCharacterTextField.addKeyListener(this.textFieldKeyListener);
        this.groupingCharacterTextField.setEnabled(false);
        this.groupNumbersBox = new JCheckBox("Digit Grouping", false);
        this.groupNumbersBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParseValueTypesWizardStep.this.groupingCharacterTextField.setEnabled(ParseValueTypesWizardStep.this.groupNumbersBox.isSelected());
                ParseValueTypesWizardStep.this.settingsChanged();
            }
        });
        this.dateFormatTextField = new JTextField();
        String format = "yyyy-MM-dd hh:mm:ss";
        try {
            format = this.reader.getParameter("date_format");
        }
        catch (UndefinedParameterError e) {
            // empty catch block
        }
        this.dateFormatTextField.setText(format);
        this.dateFormatTextField.addKeyListener(this.textFieldKeyListener);
        this.tolerateErrorCheckBox.setText("Read non matching values as missings and tolerate too short rows.");
    }

    protected char getDecimalPointCharacter() {
        return this.decimalPointCharacterTextField.getCharacter();
    }

    protected boolean groupDigits() {
        return this.groupNumbersBox.isSelected();
    }

    protected char getGroupingSeparator() {
        return this.groupingCharacterTextField.getCharacter();
    }

    protected String getDateFormat() {
        return this.dateFormatTextField.getText();
    }

    @Override
    protected void doAfterEnteringAction() {
    }

    @Override
    protected JComponent getComponent() {
        JPanel detectionPanel = new JPanel(ButtonDialog.createGridLayout(4, 2));
        detectionPanel.add(new JLabel("Guess the value types of all attributes"));
        detectionPanel.add(this.guessingButtonsPanel);
        detectionPanel.add(new JLabel("Decimal Character"));
        detectionPanel.add(this.decimalPointCharacterTextField);
        detectionPanel.add(this.groupNumbersBox);
        detectionPanel.add(this.groupingCharacterTextField);
        detectionPanel.add(new JLabel("Date Format"));
        detectionPanel.add(this.dateFormatTextField);
        detectionPanel.setBorder(ButtonDialog.createTitledBorder("Type Detection"));
        JPanel parsingPanel = new JPanel(ButtonDialog.createGridLayout(1, 2));
        parsingPanel.add(detectionPanel);
        JComponent editorPanel = super.getComponent();
        editorPanel.setBorder(null);
        JPanel panel = new JPanel(new BorderLayout(0, 6));
        panel.add((Component)parsingPanel, "North");
        panel.add((Component)editorPanel, "Center");
        return panel;
    }
}

