/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport.csv;

import com.rapidminer.gui.tools.CharTextField;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.MetaDataDeclarationEditor;
import com.rapidminer.operator.io.CSVDataReader;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.io.Encoding;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Timer;

public abstract class ParseFileWizardStep
extends WizardStep {
    private CSVDataReader reader;
    private final JCheckBox trimLinesBox = new JCheckBox("Trim Lines", true);
    private final JComboBox encodingComboBox = new JComboBox<String>(Encoding.CHARSETS);
    private final JCheckBox skipCommentsBox;
    private final JCheckBox useFirstRowAsColumnNamesBox;
    private final JCheckBox useQuotesBox;
    private final JTextField commentCharacterTextField;
    private final CharTextField quoteCharacterTextField;
    private final JLabel escapeCharacterLabel;
    private final CharTextField escapeCharacterTextField;
    private final JRadioButton commaButton;
    private final JRadioButton semicolonButton;
    private final JRadioButton tabButton;
    private final JRadioButton spaceButton;
    private final JRadioButton regexButton;
    private final JTextField regexTextField;
    private final MetaDataDeclarationEditor editor;

    public ParseFileWizardStep(String i18nKey, CSVDataReader reader) {
        super(i18nKey);
        String encoding = "SYSTEM";
        String encodingProperty = System.getProperty("rapidminer.general.encoding");
        if (encodingProperty != null) {
            encoding = encodingProperty;
        }
        this.encodingComboBox.setSelectedItem(encoding);
        this.encodingComboBox.setPreferredSize(new Dimension(this.encodingComboBox.getPreferredSize().width, 25));
        this.encodingComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParseFileWizardStep.this.settingsChanged();
            }
        });
        this.skipCommentsBox = new JCheckBox("Skip Comments", true);
        this.useFirstRowAsColumnNamesBox = new JCheckBox("Use First Row as Column Names", true);
        this.useQuotesBox = new JCheckBox("Use Quotes", true);
        this.commentCharacterTextField = new JTextField("#");
        this.quoteCharacterTextField = new CharTextField('\"');
        this.escapeCharacterLabel = new JLabel("Escape Character for Seperator:");
        this.escapeCharacterTextField = new CharTextField('\\');
        this.commaButton = new JRadioButton("Comma \",\" ");
        this.semicolonButton = new JRadioButton("Semicolon \";\"");
        this.tabButton = new JRadioButton("Tab");
        this.spaceButton = new JRadioButton("Space");
        this.regexButton = new JRadioButton("Regular Expression");
        this.regexTextField = new JTextField(",\\s*|;\\s*");
        this.trimLinesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParseFileWizardStep.this.settingsChanged();
            }
        });
        this.skipCommentsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParseFileWizardStep.this.commentCharacterTextField.setEnabled(ParseFileWizardStep.this.skipCommentsBox.isSelected());
                ParseFileWizardStep.this.settingsChanged();
            }
        });
        this.commentCharacterTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ParseFileWizardStep.this.settingsChanged();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.useFirstRowAsColumnNamesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParseFileWizardStep.this.settingsChanged();
            }
        });
        this.useQuotesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParseFileWizardStep.this.quoteCharacterTextField.setEnabled(ParseFileWizardStep.this.useQuotesBox.isSelected());
                ParseFileWizardStep.this.escapeCharacterTextField.setEnabled(ParseFileWizardStep.this.useQuotesBox.isSelected());
                ParseFileWizardStep.this.settingsChanged();
            }
        });
        this.quoteCharacterTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ParseFileWizardStep.this.settingsChanged();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.escapeCharacterTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ParseFileWizardStep.this.settingsChanged();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.regexButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParseFileWizardStep.this.regexTextField.setEnabled(ParseFileWizardStep.this.regexButton.isSelected());
                ParseFileWizardStep.this.settingsChanged();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.commaButton);
        buttonGroup.add(this.semicolonButton);
        buttonGroup.add(this.spaceButton);
        buttonGroup.add(this.tabButton);
        buttonGroup.add(this.regexButton);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParseFileWizardStep.this.settingsChanged();
            }
        };
        this.commaButton.addActionListener(listener);
        this.semicolonButton.addActionListener(listener);
        this.spaceButton.addActionListener(listener);
        this.tabButton.addActionListener(listener);
        this.regexButton.addActionListener(listener);
        this.regexTextField.addKeyListener(new KeyListener(){
            private Timer timer = new Timer(2000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    timer.stop();
                    ParseFileWizardStep.this.settingsChanged();
                }
            });

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.timer.stop();
                this.timer.start();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.reader = reader;
        this.editor = new MetaDataDeclarationEditor(reader, false);
        this.skipCommentsBox.setSelected(reader.getParameterAsBoolean("skip_comments"));
        this.useFirstRowAsColumnNamesBox.setSelected(reader.getParameterAsBoolean("use_first_row_as_attribute_names"));
        this.useQuotesBox.setSelected(reader.getParameterAsBoolean("use_quotes"));
        String sep = ",\\s*|;\\s*";
        this.regexButton.setSelected(true);
        try {
            sep = reader.getParameter("column_separators");
        }
        catch (UndefinedParameterError e1) {
            e1.printStackTrace();
        }
        if (sep.equals(",")) {
            this.commaButton.setSelected(true);
        }
        if (sep.equals(";")) {
            this.semicolonButton.setSelected(true);
        }
        if (sep.equals("\t")) {
            this.tabButton.setSelected(true);
        }
        if (sep.equals("\\s")) {
            this.spaceButton.setSelected(true);
        }
    }

    protected Charset getEncoding() {
        return Encoding.getEncoding((String)this.encodingComboBox.getSelectedItem());
    }

    protected boolean trimLines() {
        return this.trimLinesBox.isSelected();
    }

    protected boolean skipComments() {
        return this.skipCommentsBox.isSelected();
    }

    protected String getCommentCharacters() {
        return this.commentCharacterTextField.getText();
    }

    protected boolean useQuotes() {
        return this.useQuotesBox.isSelected();
    }

    protected char getQuotesCharacter() {
        return this.quoteCharacterTextField.getCharacter();
    }

    protected char getEscapeCharacter() {
        return this.escapeCharacterTextField.getCharacter();
    }

    protected String getSplitExpression() {
        String splitExpression = null;
        if (this.regexButton.isSelected()) {
            splitExpression = this.regexTextField.getText();
            if ("".equals(splitExpression)) {
                splitExpression = null;
            } else {
                try {
                    Pattern.compile(splitExpression);
                }
                catch (PatternSyntaxException pse) {
                    splitExpression = null;
                }
            }
        } else if (this.commaButton.isSelected()) {
            splitExpression = ",";
        } else if (this.semicolonButton.isSelected()) {
            splitExpression = ";";
        } else if (this.tabButton.isSelected()) {
            splitExpression = "\t";
        } else if (this.spaceButton.isSelected()) {
            splitExpression = "\\s";
        }
        return splitExpression;
    }

    protected abstract void settingsChanged();

    protected void setData(List<Object[]> data) {
        this.editor.setData(data);
    }

    protected boolean getUseFirstRowAsColumnNames() {
        return this.useFirstRowAsColumnNamesBox.isSelected();
    }

    @Override
    protected JComponent getComponent() {
        JPanel optionPanel = new JPanel(ButtonDialog.createGridLayout(4, 1));
        optionPanel.add(new JPanel(ButtonDialog.createGridLayout(1, 2)){
            private static final long serialVersionUID = -1726235838693547187L;
            {
                this.add(new JLabel("File Encoding"));
                this.add(ParseFileWizardStep.this.encodingComboBox);
            }
        });
        optionPanel.add(new JPanel(ButtonDialog.createGridLayout(1, 1)){
            private static final long serialVersionUID = -1726235838693547187L;
            {
                this.add(ParseFileWizardStep.this.trimLinesBox);
            }
        });
        optionPanel.add(new JPanel(ButtonDialog.createGridLayout(1, 2)){
            private static final long serialVersionUID = -1726235838693547187L;
            {
                this.add(ParseFileWizardStep.this.skipCommentsBox);
                this.add(ParseFileWizardStep.this.commentCharacterTextField);
            }
        });
        optionPanel.add(new JPanel(ButtonDialog.createGridLayout(1, 1)){
            private static final long serialVersionUID = -1726235838693547187L;
            {
                this.add(ParseFileWizardStep.this.useFirstRowAsColumnNamesBox);
            }
        });
        optionPanel.setBorder(ButtonDialog.createTitledBorder("File Reading"));
        JPanel separationPanel = new JPanel(ButtonDialog.createGridLayout(5, 2));
        separationPanel.add(this.commaButton);
        separationPanel.add(this.spaceButton);
        separationPanel.add(this.semicolonButton);
        separationPanel.add(this.tabButton);
        separationPanel.add(this.regexButton);
        separationPanel.add(this.regexTextField);
        separationPanel.add(this.escapeCharacterLabel);
        separationPanel.add(this.escapeCharacterTextField);
        separationPanel.add(this.useQuotesBox);
        separationPanel.add(this.quoteCharacterTextField);
        separationPanel.setBorder(ButtonDialog.createTitledBorder("Column Separation"));
        JPanel parsingPanel = new JPanel(ButtonDialog.createGridLayout(1, 2));
        parsingPanel.add(optionPanel);
        parsingPanel.add(separationPanel);
        this.editor.setBorder(null);
        JPanel panel = new JPanel(new BorderLayout(0, 6));
        panel.add((Component)parsingPanel, "North");
        panel.add((Component)this.editor, "Center");
        return panel;
    }
}

