/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport.csv;

import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.container.Range;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class DataEvaluator {
    private final NumberFormat numberFormat;
    private int rowCount = 0;
    private int columnCount = 0;
    private String[] columnNames = null;
    private boolean[] canParseDouble = null;
    private boolean[] canParseInteger = null;
    private double[] minValues = null;
    private double[] maxValues = null;
    private int[] numberOfMissings = null;
    private ArrayList<LinkedHashSet<String>> valueSets = new ArrayList();
    private int[] valueTypes = null;
    private boolean complete = false;

    public DataEvaluator(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.start();
    }

    public void start() {
        this.rowCount = 0;
        this.columnCount = 0;
        this.columnNames = null;
        this.canParseDouble = new boolean[this.columnCount];
        this.canParseInteger = new boolean[this.columnCount];
        this.minValues = new double[this.columnCount];
        this.maxValues = new double[this.columnCount];
        this.numberOfMissings = new int[this.columnCount];
        this.valueTypes = null;
        this.valueSets.clear();
        this.complete = false;
    }

    public void setColumnNames(String[] columnNames) {
        if (this.columnCount < columnNames.length) {
            this.columnNames = new String[columnNames.length];
            for (int i = 0; i < columnNames.length; ++i) {
                this.columnNames[i] = columnNames[i];
            }
            this.extendToLength(columnNames.length);
        } else {
            this.columnNames = columnNames;
        }
    }

    public void setValueTypes(int[] valueTypes) {
        if (this.columnCount < valueTypes.length) {
            this.valueTypes = new int[valueTypes.length];
            for (int i = 0; i < valueTypes.length; ++i) {
                this.valueTypes[i] = valueTypes[i];
            }
            this.extendToLength(valueTypes.length);
        } else {
            this.valueTypes = valueTypes;
        }
    }

    public void update(String[] values) {
        if (this.columnCount < values.length) {
            this.extendToLength(values.length);
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i].isEmpty()) {
                int n = i;
                this.numberOfMissings[n] = this.numberOfMissings[n] + 1;
                continue;
            }
            this.valueSets.get(i).add(values[i]);
            if (!this.canParseDouble[i]) continue;
            try {
                Number number = this.numberFormat.parse(values[i]);
                if (this.minValues[i] > number.doubleValue()) {
                    this.minValues[i] = number.doubleValue();
                }
                if (this.maxValues[i] < number.doubleValue()) {
                    this.maxValues[i] = number.doubleValue();
                }
                if (!this.canParseInteger[i] || Tools.isEqual(Math.round(number.doubleValue()), number.intValue())) continue;
                this.canParseInteger[i] = false;
                continue;
            }
            catch (ParseException e) {
                this.canParseDouble[i] = false;
                this.canParseInteger[i] = false;
            }
        }
        ++this.rowCount;
    }

    private void extendToLength(int length) {
        int i;
        boolean[] newCanParseDouble = new boolean[length];
        boolean[] newCanParseInteger = new boolean[length];
        double[] newMinValues = new double[length];
        double[] newMaxValues = new double[length];
        int[] newNumberOfMissings = new int[length];
        for (i = 0; i < length; ++i) {
            newCanParseDouble[i] = true;
            newCanParseInteger[i] = true;
            newMinValues[i] = Double.MAX_VALUE;
            newMaxValues[i] = Double.MIN_VALUE;
            newNumberOfMissings[i] = 0;
        }
        for (i = 0; i < this.columnCount; ++i) {
            newCanParseDouble[i] = this.canParseDouble[i];
            newCanParseInteger[i] = this.canParseInteger[i];
            newMinValues[i] = this.minValues[i];
            newMaxValues[i] = this.maxValues[i];
            newNumberOfMissings[i] = this.numberOfMissings[i];
        }
        this.canParseDouble = newCanParseDouble;
        this.canParseInteger = newCanParseInteger;
        this.minValues = newMinValues;
        this.maxValues = newMaxValues;
        this.numberOfMissings = newNumberOfMissings;
        int difference = length - this.valueSets.size();
        for (int i2 = 0; i2 < difference; ++i2) {
            this.valueSets.add(new LinkedHashSet());
        }
        this.columnCount = length;
    }

    public void finish(boolean complete) {
        int i;
        this.complete = complete;
        if (this.columnNames == null) {
            this.columnNames = new String[this.columnCount];
        } else if (this.columnCount > this.columnNames.length) {
            String[] newColumnNames = new String[this.columnNames.length];
            for (int i2 = 0; i2 < this.columnNames.length; ++i2) {
                newColumnNames[i2] = this.columnNames[i2];
            }
            this.columnNames = newColumnNames;
        }
        for (i = 0; i < this.columnNames.length; ++i) {
            if (this.columnNames[i] != null && !this.columnNames[i].isEmpty()) continue;
            this.columnNames[i] = this.getGenericColumnName(i);
        }
        this.valueTypes = new int[this.columnCount];
        for (i = 0; i < this.columnCount; ++i) {
            this.valueTypes[i] = this.canParseInteger[i] ? 3 : (this.canParseDouble[i] ? 4 : (this.valueSets.get(i).size() <= 2 ? 6 : 1));
        }
    }

    protected String[] getColumnNames() {
        return this.columnNames;
    }

    protected int getColumnCount() {
        return this.columnCount;
    }

    protected int getRowCount() {
        return this.rowCount;
    }

    protected int[] getValueTypes() {
        return this.valueTypes;
    }

    protected int[] getNumberOfMissings() {
        return this.numberOfMissings;
    }

    protected Set<String> getValueSet(int column) {
        return this.valueSets.get(column);
    }

    protected boolean isGuess() {
        return !this.complete;
    }

    public ExampleSetMetaData getMetaData() {
        ExampleSetMetaData metaData = new ExampleSetMetaData();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            AttributeMetaData amd = new AttributeMetaData(this.getColumnNames()[i], this.getValueTypes()[i]);
            MDInteger missings = new MDInteger(this.getNumberOfMissings()[i]);
            SetRelation relation = SetRelation.EQUAL;
            if (this.isGuess()) {
                relation = SetRelation.SUPERSET;
                missings.increaseByUnknownAmount();
            }
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.getValueTypes()[i], 2)) {
                amd.setValueRange(new Range(this.minValues[i], this.maxValues[i]), relation);
            } else {
                amd.setValueSet(this.getValueSet(i), relation);
            }
            amd.setNumberOfMissingValues(missings);
            metaData.addAttribute(amd);
        }
        metaData.setNumberOfExamples(new MDInteger(this.getRowCount()));
        if (this.isGuess()) {
            metaData.getNumberOfExamples().increaseByUnknownAmount();
            metaData.attributesAreSuperset();
        }
        return metaData;
    }

    public abstract String getGenericColumnName(int var1);
}

