/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport.csv;

import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.SimpleFileFilter;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.DataImportWizard;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.FileSelectionWizardStep;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.RepositoryLocationSelectionWizardStep;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.csv.ParseFileWizardStep;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.csv.ParseValueTypesWizardStep;
import com.rapidminer.gui.wizards.AbstractConfigurationWizardCreator;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.CSVDataReader;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.OperatorService;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class CSVImportWizard
extends DataImportWizard {
    private static final long serialVersionUID = -4308448171060612833L;
    private File file = null;
    private CSVDataReader reader = null;
    private Parameters parametersBackup = null;

    public CSVImportWizard(String i18nKey, Object ... i18nArgs) {
        this(i18nKey, (ConfigurationListener)null, null, true, null, i18nArgs);
    }

    public CSVImportWizard(String i18nKey, ConfigurationListener listener, File preselectedFile, boolean showStoreInRepositoryStep, RepositoryLocation preselectedLocation, Object ... i18nArgs) {
        super(i18nKey, i18nArgs);
        this.file = preselectedFile;
        if (listener != null) {
            this.reader = (CSVDataReader)listener;
        } else {
            try {
                this.reader = OperatorService.createOperator(CSVDataReader.class);
            }
            catch (OperatorCreationException e) {
                e.printStackTrace();
            }
        }
        this.parametersBackup = (Parameters)this.reader.getParameters().clone();
        this.addStep(new FileSelectionWizardStep(this, new FileFilter[]{new SimpleFileFilter("CSV File (.csv)", ".csv")}){

            @Override
            protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
                if (CSVImportWizard.this.file != null && CSVImportWizard.this.file.exists()) {
                    this.fileChooser.setSelectedFile(CSVImportWizard.this.file);
                }
                return true;
            }

            @Override
            protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                CSVImportWizard.this.file = this.getSelectedFile();
                File oldFile = null;
                try {
                    oldFile = CSVImportWizard.this.reader.getParameterAsFile("file_name");
                }
                catch (UndefinedParameterError e) {
                    oldFile = null;
                }
                if (oldFile == null || !oldFile.equals(CSVImportWizard.this.file)) {
                    CSVImportWizard.this.reader.clearAllReaderSettings();
                }
                CSVImportWizard.this.reader.setParameter("file_name", CSVImportWizard.this.file.getAbsolutePath());
                return true;
            }
        });
        this.addStep(new ParseFileWizardStep("specify_csv_parsing_options", this.reader){

            @Override
            protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
                CSVImportWizard.this.reader.stopReading();
                if (CSVImportWizard.this.reader.attributeNamesDefinedByUser()) {
                    CSVImportWizard.this.reader.loadMetaDataFromParameters();
                    LinkedList<Object[]> dummyData = new LinkedList<Object[]>();
                    this.setData(dummyData);
                    new ProgressThread("load_csv_file"){

                        @Override
                        public void run() {
                            List<Object[]> data;
                            try {
                                data = CSVImportWizard.this.reader.getPreviewAsList(this.getProgressListener(), true);
                            }
                            catch (OperatorException e) {
                                SwingTools.showVerySimpleErrorMessage(e.getMessage(), e);
                                return;
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    this.setData(data);
                                }
                            });
                        }
                    }.start();
                } else {
                    this.settingsChanged();
                }
                return true;
            }

            @Override
            protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                CSVImportWizard.this.reader.stopReading();
                return true;
            }

            @Override
            protected void settingsChanged() {
                CSVImportWizard.this.reader.clearAllReaderSettings();
                CSVImportWizard.this.reader.setParameter("encoding", this.getEncoding().displayName());
                CSVImportWizard.this.reader.setParameter("trim_lines", Boolean.toString(this.trimLines()));
                CSVImportWizard.this.reader.setParameter("skip_comments", Boolean.toString(this.skipComments()));
                CSVImportWizard.this.reader.setParameter("comment_characters", this.getCommentCharacters());
                CSVImportWizard.this.reader.setParameter("use_first_row_as_attribute_names", Boolean.toString(this.getUseFirstRowAsColumnNames()));
                CSVImportWizard.this.reader.setParameter("use_quotes", Boolean.toString(this.useQuotes()));
                CSVImportWizard.this.reader.setParameter("quotes_character", Character.toString(this.getQuotesCharacter()));
                CSVImportWizard.this.reader.setParameter("escape_character_for_quotes", Character.toString(this.getEscapeCharacter()));
                CSVImportWizard.this.reader.setParameter("column_separators", this.getSplitExpression());
                LinkedList<Object[]> dummyData = new LinkedList<Object[]>();
                this.setData(dummyData);
                new ProgressThread("load_csv_file"){

                    @Override
                    public void run() {
                        List<Object[]> data;
                        try {
                            data = CSVImportWizard.this.reader.getPreviewAsList(this.getProgressListener(), true);
                        }
                        catch (OperatorException e) {
                            SwingTools.showVerySimpleErrorMessage(e.getMessage(), e);
                            return;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.setData(data);
                            }
                        });
                    }
                }.start();
            }

            @Override
            protected boolean canGoBack() {
                return true;
            }

            @Override
            protected boolean canProceed() {
                return true;
            }
        });
        this.addStep(new ParseValueTypesWizardStep("value_type_selection", this.reader){

            @Override
            protected boolean canGoBack() {
                return true;
            }

            @Override
            protected boolean canProceed() {
                return true;
            }

            @Override
            protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
                if (this.reader.attributeNamesDefinedByUser()) {
                    this.reader.loadMetaDataFromParameters();
                }
                super.performEnteringAction(direction);
                return true;
            }

            @Override
            protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                this.reader.stopReading();
                this.reader.writeMetaDataInParameter();
                return true;
            }
        });
        if (showStoreInRepositoryStep) {
            this.addStep(new RepositoryLocationSelectionWizardStep(this, preselectedLocation != null ? preselectedLocation.getAbsoluteLocation() : null){

                @Override
                protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                    return CSVImportWizard.this.transferData(CSVImportWizard.this.reader, this.getRepositoryLocation());
                }
            });
        }
        this.layoutDefault(9);
    }

    @Override
    public void cancel() {
        this.reader.getParameters().setAll(this.parametersBackup);
        this.reader.stopReading();
        super.cancel();
    }

    @Override
    public void finish() {
        this.reader.stopReading();
        super.finish();
    }

    public static class CSVDataReaderWizardCreator
    extends AbstractConfigurationWizardCreator {
        private static final long serialVersionUID = 1L;

        @Override
        public void createConfigurationWizard(ParameterType type, ConfigurationListener listener) {
            String fileLocation = "";
            try {
                fileLocation = listener.getParameters().getParameter("file_name");
                if (fileLocation == null) {
                    throw new UndefinedParameterError("");
                }
                File file = new File(fileLocation);
                new CSVImportWizard(this.getI18NKey(), listener, file, false, null, new Object[0]).setVisible(true);
            }
            catch (UndefinedParameterError e) {
                new CSVImportWizard(this.getI18NKey(), listener, null, false, null, new Object[0]).setVisible(true);
            }
        }

        @Override
        public String getI18NKey() {
            return "data_import_wizard";
        }
    }
}

