/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport.csv;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.csv.DataEvaluator;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.csv.LineReader;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.tools.CSVParseException;
import com.rapidminer.tools.LineParser;
import com.rapidminer.tools.Ontology;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jfree.util.Log;

public class CSVFileReader {
    private static final int MAX_LINES = 2000;
    private final File file;
    private final boolean useFirstRowAsColumnNames;
    private final LineParser parser;
    private final NumberFormat numberFormat;
    private boolean eofReached = false;
    private int rowCount = -1;
    private final DataEvaluator dataEvaluator;

    public CSVFileReader(final File file, boolean useFirstRowAsColumnNames, LineParser parser, NumberFormat numberFormat) {
        this.file = file;
        this.useFirstRowAsColumnNames = useFirstRowAsColumnNames;
        this.parser = parser;
        this.numberFormat = numberFormat;
        this.dataEvaluator = new DataEvaluator(numberFormat){

            @Override
            public String getGenericColumnName(int column) {
                return file.getName() + "_" + (column + 1);
            }
        };
    }

    public LinkedList<String[]> readData(int maxLines) throws IOException {
        String line = null;
        this.eofReached = false;
        boolean first = true;
        LineReader reader = new LineReader(this.file);
        LinkedList<String[]> valueLines = new LinkedList<String[]>();
        this.dataEvaluator.start();
        do {
            if ((line = reader.readLine()) != null) {
                String[] valueLine = this.parser.parse(line);
                if (valueLine != null) {
                    if (first) {
                        first = false;
                        if (this.useFirstRowAsColumnNames) {
                            this.dataEvaluator.setColumnNames(valueLine);
                            continue;
                        }
                    }
                    this.dataEvaluator.update(valueLine);
                    valueLines.add(valueLine);
                }
                ++this.rowCount;
                continue;
            }
            this.eofReached = true;
            break;
        } while (this.rowCount < maxLines);
        reader.close();
        this.dataEvaluator.finish(this.eofReached);
        return valueLines;
    }

    private void guessMetaData() throws IOException {
        this.readData(2000);
    }

    public MetaData getMetaData() throws IOException {
        this.guessMetaData();
        return this.dataEvaluator.getMetaData();
    }

    public ExampleSet createExampleSet() throws IOException {
        this.guessMetaData();
        ExampleSetMetaData metaData = this.dataEvaluator.getMetaData();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(metaData.getAllAttributes().size());
        for (AttributeMetaData amd : metaData.getAllAttributes()) {
            attributes.add(AttributeFactory.createAttribute(amd.getName(), amd.getValueType()));
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes, this.getDataRowReader(attributes));
        return table.createExampleSet();
    }

    public Iterator<String[]> getDataReader() throws IOException {
        Iterator<String[]> iterator = new Iterator<String[]>(){
            private String line = null;
            private boolean first = CSVFileReader.access$000(CSVFileReader.this);
            private LineReader reader = new LineReader(CSVFileReader.access$100(CSVFileReader.this));

            @Override
            public boolean hasNext() {
                try {
                    if (this.first) {
                        do {
                            this.line = this.reader.readLine();
                            if (this.line != null) continue;
                            return false;
                        } while (CSVFileReader.this.parser.parse(this.line) == null);
                        this.first = false;
                    }
                    do {
                        this.line = this.reader.readLine();
                        if (this.line != null) continue;
                        this.reader.close();
                        return false;
                    } while (CSVFileReader.this.parser.parse(this.line) == null);
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }

            @Override
            public String[] next() {
                try {
                    return CSVFileReader.this.parser.parse(this.line);
                }
                catch (CSVParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can not remove data rows from reader.");
            }
        };
        return iterator;
    }

    public DataRowReader getDataRowReader(final List<Attribute> attributeList) throws IOException {
        DataRowReader dataRowReader = new DataRowReader(){
            private Iterator<String[]> iterator;
            private int columnCount;
            private Attribute[] attributes;
            {
                this.iterator = CSVFileReader.this.getDataReader();
                this.columnCount = attributeList.size();
                this.attributes = new Attribute[this.columnCount];
                this.attributes = attributeList.toArray(this.attributes);
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public DataRow next() {
                int i;
                String[] valueLine = this.iterator.next();
                double[] values = new double[this.columnCount];
                for (i = 0; i < this.columnCount; ++i) {
                    values[i] = Double.NaN;
                }
                for (i = 0; i < valueLine.length; ++i) {
                    if (i >= valueLine.length) {
                        Log.warn((Object)"Metadata was not correctly specified.");
                        continue;
                    }
                    if (valueLine[i] == null || valueLine[i].isEmpty()) continue;
                    if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.attributes[i].getValueType(), 2)) {
                        try {
                            values[i] = CSVFileReader.this.numberFormat.parse(valueLine[i]).doubleValue();
                        }
                        catch (ParseException e) {
                            System.err.println("cannot parse");
                        }
                        continue;
                    }
                    if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.attributes[i].getValueType(), 1)) continue;
                    values[i] = this.attributes[i].getMapping().mapString(valueLine[i]);
                }
                return new DoubleArrayDataRow(values);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can not remove data rows from reader.");
            }
        };
        return dataRowReader;
    }

    static /* synthetic */ boolean access$000(CSVFileReader x0) {
        return x0.useFirstRowAsColumnNames;
    }

    static /* synthetic */ File access$100(CSVFileReader x0) {
        return x0.file;
    }
}

